/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamlpath;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.github.yamlpath.YamlExpressionParser;
import io.github.yamlpath.utils.SerializationUtils;
import io.github.yamlpath.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class YamlPath {
    private YamlPath() {
    }

    public static YamlExpressionParser from(InputStream ... inputStreams) throws IOException {
        ArrayList<Map<Object, Object>> resources = new ArrayList<Map<Object, Object>>();
        for (InputStream is : inputStreams) {
            String yaml = StringUtils.readAllBytes(is);
            resources.addAll(YamlPath.fromContent(yaml));
        }
        return new YamlExpressionParser(resources);
    }

    public static YamlExpressionParser from(String ... yamls) {
        ArrayList<Map<Object, Object>> resources = new ArrayList<Map<Object, Object>>();
        for (String yaml : yamls) {
            try {
                resources.addAll(YamlPath.fromContent(yaml));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new YamlExpressionParser(resources);
    }

    private static Collection<Map<Object, Object>> fromContent(String content) throws JsonProcessingException {
        try {
            return SerializationUtils.unmarshalAsListOfMaps(content);
        }
        catch (IOException e) {
            return (Collection)SerializationUtils.yamlMapper().readValue(content, (TypeReference)new TypeReference<List<Map<Object, Object>>>(){});
        }
    }
}

