/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamlpath.processor;

import io.github.yamlpath.WorkUnit;
import io.github.yamlpath.processor.PathProcessor;
import io.github.yamlpath.processor.expressions.ExpressionProcessor;
import io.github.yamlpath.utils.PathUtils;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ExpressionPathProcessor
implements PathProcessor {
    private static final String AND = "&&";
    private static final String OR = "||";
    private final List<ExpressionProcessor> supportedExpressions = StreamSupport.stream(ServiceLoader.load(ExpressionProcessor.class, ExpressionPathProcessor.class.getClassLoader()).spliterator(), false).sorted(Comparator.comparingInt(ExpressionProcessor::getPriority).reversed()).collect(Collectors.toList());

    @Override
    public boolean canHandle(WorkUnit.Path path) {
        return this.supportedExpressions.stream().anyMatch(e -> path.getPart().contains(e.operator()));
    }

    @Override
    public Object handle(WorkUnit workUnit, WorkUnit.Path path) {
        boolean applies;
        String expression = path.getPart();
        if (expression.contains(AND)) {
            String[] subExpressions = expression.split(Pattern.quote(AND));
            applies = Stream.of(subExpressions).allMatch(e -> this.evaluate(path, (String)e));
        } else if (expression.contains(OR)) {
            String[] subExpressions = expression.split(Pattern.quote(OR));
            applies = Stream.of(subExpressions).anyMatch(e -> this.evaluate(path, (String)e));
        } else {
            applies = this.evaluate(path, expression);
        }
        return applies ? path.getTree() : null;
    }

    private boolean evaluate(WorkUnit.Path path, String expression) {
        for (ExpressionProcessor supported : this.supportedExpressions) {
            if (!expression.contains(supported.operator())) continue;
            String[] parts = expression.split(supported.operator());
            String left = PathUtils.normalize(parts[0]);
            String right = PathUtils.normalize(parts[1]);
            return supported.evaluate(left, right, path.getTree());
        }
        return false;
    }
}

