/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamlpath.processor;

import io.github.yamlpath.WorkUnit;
import io.github.yamlpath.processor.PathProcessor;
import io.github.yamlpath.setters.ListAtPositionSetter;
import java.util.List;

public class IndexPartPathProcessor
implements PathProcessor {
    @Override
    public boolean canHandle(WorkUnit.Path path) {
        return path.getPart().contains("[") && path.getPart().endsWith("]");
    }

    @Override
    public Object handle(WorkUnit workUnit, WorkUnit.Path path) {
        int indexOfIndexOpen = path.getPart().indexOf("[");
        String actualPart = path.getPart().substring(0, indexOfIndexOpen);
        Object value = path.getTree().get(actualPart);
        if (value instanceof List) {
            int indexOfIndexClose = path.getPart().indexOf("]");
            int position = Integer.parseInt(path.getPart().substring(indexOfIndexOpen + 1, indexOfIndexClose));
            workUnit.setSetter(new ListAtPositionSetter((List)value, position));
            return ((List)value).get(position);
        }
        throw new IllegalStateException("Expected a collection at " + path.getPart());
    }
}

