/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamlpath.processor;

import io.github.yamlpath.WorkUnit;
import io.github.yamlpath.processor.PathProcessor;
import io.github.yamlpath.setters.ListAtPositionSetter;
import io.github.yamlpath.setters.ListSetter;
import io.github.yamlpath.setters.MapAtKeySetter;
import io.github.yamlpath.setters.MapSetter;
import io.github.yamlpath.setters.MultipleSetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WildcardPartPathProcessor
implements PathProcessor {
    @Override
    public boolean canHandle(WorkUnit.Path path) {
        return path.getPart().startsWith("*");
    }

    @Override
    public Object handle(WorkUnit workUnit, WorkUnit.Path path) {
        MultipleSetter setter = new MultipleSetter();
        WorkUnit.Path effectivePath = workUnit.nextPath();
        ArrayList<Object> allFound = new ArrayList<Object>();
        this.findAll(setter, effectivePath.getPart(), effectivePath.getTree(), allFound);
        workUnit.setSetter(setter);
        return allFound;
    }

    private void findAll(MultipleSetter setter, String part, Map<Object, Object> node, List<Object> allFound) {
        Object found;
        Integer position = null;
        String actualPart = part;
        if (part.contains("[")) {
            int indexOfIndexOpen = part.indexOf("[");
            actualPart = part.substring(0, indexOfIndexOpen);
            int indexOfIndexClose = part.indexOf("]");
            position = Integer.parseInt(part.substring(indexOfIndexOpen + 1, indexOfIndexClose));
        }
        if ((found = node.get(actualPart)) != null) {
            if (found instanceof List) {
                List value = (List)found;
                if (position != null) {
                    if (position >= value.size()) {
                        return;
                    }
                    setter.add(new ListAtPositionSetter(value, position));
                    allFound.add(value.get(position));
                } else {
                    setter.add(new ListSetter(value));
                    allFound.addAll(value);
                }
            } else {
                if (position != null) {
                    return;
                }
                if (found instanceof Map) {
                    Map value = (Map)found;
                    allFound.add(value);
                    setter.add(new MapSetter(value, new MapAtKeySetter(node, part)));
                } else {
                    allFound.add(found);
                    setter.add(new MapAtKeySetter(node, part));
                }
            }
        }
        for (Object child : node.values()) {
            if (child instanceof Map) {
                this.findAll(setter, part, (Map)child, allFound);
                continue;
            }
            if (!(child instanceof List)) continue;
            List items = (List)child;
            for (Object item : items) {
                if (!(item instanceof Map)) continue;
                this.findAll(setter, part, (Map)item, allFound);
            }
        }
    }
}

