/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamlpath.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.github.yamlpath.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SerializationUtils {
    private static final String DOCUMENT_DELIMITER = "---";
    private static final ObjectMapper YAML_MAPPER = SerializationUtils.createYamlMapper(new YAMLGenerator.Feature[]{YAMLGenerator.Feature.MINIMIZE_QUOTES, YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR}, new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT}, new SerializationFeature[]{SerializationFeature.WRITE_NULL_MAP_VALUES, SerializationFeature.WRITE_EMPTY_JSON_ARRAYS});

    private SerializationUtils() {
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER;
    }

    public static List<Map<Object, Object>> unmarshalAsListOfMaps(InputStream inputStream) throws IOException {
        return SerializationUtils.unmarshalAsListOfMaps(StringUtils.readAllBytes(inputStream));
    }

    public static List<Map<Object, Object>> unmarshalAsListOfMaps(String content) throws IOException {
        String[] parts = SerializationUtils.splitDocument(content);
        ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
        for (String part : parts) {
            if (part.trim().isEmpty()) continue;
            list.add((Map)SerializationUtils.yamlMapper().readValue(part, (TypeReference)new TypeReference<Map<Object, Object>>(){}));
        }
        return list;
    }

    private static String[] splitDocument(String aSpecFile) {
        ArrayList<String> documents = new ArrayList<String>();
        String[] lines = aSpecFile.split("\\r?\\n");
        StringBuilder builder = new StringBuilder();
        for (int nLine = 0; nLine < lines.length; ++nLine) {
            if (lines[nLine].length() >= DOCUMENT_DELIMITER.length() && !lines[nLine].substring(0, DOCUMENT_DELIMITER.length()).equals(DOCUMENT_DELIMITER) || lines[nLine].length() < DOCUMENT_DELIMITER.length()) {
                builder.append(lines[nLine] + System.lineSeparator());
                continue;
            }
            documents.add(builder.toString());
            builder.setLength(0);
            for (int i = 0; i <= nLine; ++i) {
                builder.append(System.lineSeparator());
            }
        }
        if (!builder.toString().isEmpty()) {
            documents.add(builder.toString());
        }
        return documents.toArray(new String[documents.size()]);
    }

    private static YAMLFactory createYamlFactory(YAMLGenerator.Feature[] features) {
        YAMLFactory result = new YAMLFactory();
        for (YAMLGenerator.Feature feature : features) {
            result = result.enable(feature);
        }
        return result;
    }

    private static ObjectMapper createYamlMapper(YAMLGenerator.Feature[] generatorFeatures, final SerializationFeature[] enabledFeatures, final SerializationFeature[] disabledFeatures) {
        return new ObjectMapper((JsonFactory)SerializationUtils.createYamlFactory(generatorFeatures)){
            {
                super(jf);
                for (SerializationFeature feature : enabledFeatures) {
                    this.configure(feature, true);
                }
                for (SerializationFeature feature : disabledFeatures) {
                    this.configure(feature, false);
                }
            }
        };
    }
}

