/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.KtCompiler;
import io.gitlab.arturbosch.detekt.core.ModificationNotification;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000bJ\f\u0010\r\u001a\u00020\u000e*\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtFileModifier;", "", "project", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "saveModifiedFiles", "", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "notification", "Lkotlin/Function1;", "Lio/gitlab/arturbosch/detekt/api/Notification;", "unnormalizeContent", "", "detekt-core"})
public final class KtFileModifier {
    private final Path project;

    public final void saveModifiedFiles(@NotNull List<? extends KtFile> ktFiles, @NotNull Function1<? super Notification, Unit> notification) {
        Pair pair;
        Collection collection;
        KtFile it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(ktFiles, (String)"ktFiles");
        Intrinsics.checkParameterIsNotNull(notification, (String)"notification");
        Iterable $receiver$iv = ktFiles;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (KtFile)element$iv$iv;
            if (!(it.getModificationStamp() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            pair = TuplesKt.to((Object)JunkKt.absolutePath(it), (Object)this.unnormalizeContent(it));
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!(it.getFirst() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            pair = TuplesKt.to((Object)this.project.resolve((String)it.getFirst()), (Object)it.getSecond());
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            byte[] byArray;
            Pair it2 = (Pair)element$iv;
            Object object = it2.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first");
            notification.invoke((Object)new ModificationNotification((Path)object));
            String string = (String)it2.getSecond();
            Path path = (Path)it2.getFirst();
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
            Files.write(path, byArray, new OpenOption[0]);
        }
    }

    private final String unnormalizeContent(@NotNull KtFile $receiver) {
        boolean bl;
        String lineSeparator = (String)$receiver.getUserData(KtCompiler.Companion.getLINE_SEPARATOR());
        boolean bl2 = bl = lineSeparator != null;
        if (!bl) {
            String string = "No line separator entry for ktFile " + JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)$receiver).asString();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = StringUtilRt.convertLineSeparators((String)$receiver.getText(), (String)lineSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtilRt.convertLine\u2026tors(text, lineSeparator)");
        return string;
    }

    public KtFileModifier(@NotNull Path project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

