/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.KtCompiler;
import io.gitlab.arturbosch.detekt.core.KtTreeCompiler;
import io.gitlab.arturbosch.detekt.core.KtTreeCompiler$sam$java_util_function_Predicate$0;
import io.gitlab.arturbosch.detekt.core.PathFilter;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J4\u0010\u0012\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000e0\u000e \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00130\u00132\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\f\u0010\u0015\u001a\u00020\b*\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler;", "", "compiler", "Lio/gitlab/arturbosch/detekt/core/KtCompiler;", "filters", "", "Lio/gitlab/arturbosch/detekt/core/PathFilter;", "parallel", "", "debug", "(Lio/gitlab/arturbosch/detekt/core/KtCompiler;Ljava/util/List;ZZ)V", "compile", "Lorg/jetbrains/kotlin/psi/KtFile;", "path", "Ljava/nio/file/Path;", "compileInternal", "project", "notIgnored", "streamFor", "Ljava/util/stream/Stream;", "kotlin.jvm.PlatformType", "isKotlinFile", "Companion", "detekt-core"})
public final class KtTreeCompiler {
    private final KtCompiler compiler;
    private final List<PathFilter> filters;
    private final boolean parallel;
    private final boolean debug;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<KtFile> compile(@NotNull Path path) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        boolean bl = Files.exists(path, new LinkOption[0]);
        if (!bl) {
            String string = "Given path " + path + " does not exist!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (JunkKt.isFile(path) && this.isKotlinFile(path)) {
            list = CollectionsKt.listOf((Object)this.compiler.compile(path, path));
        } else if (JunkKt.isDirectory(path)) {
            list = this.compileInternal(path);
        } else {
            if (this.debug) {
                String string = "Ignoring a file detekt cannot handle: " + path;
                System.out.println((Object)string);
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Stream<Path> streamFor(Path project) {
        Stream<Path> stream;
        Stream<Path> $receiver = stream = Files.walk(project, new FileVisitOption[0]);
        if (this.parallel) {
            $receiver.parallel();
        }
        return stream;
    }

    private final List<KtFile> compileInternal(Path project) {
        Stream<Path> stream = this.streamFor(project);
        Object object = compileInternal.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new KtTreeCompiler$sam$java_util_function_Predicate$0(function1);
        }
        Stream stream2 = stream.filter((Predicate)object).filter(new Predicate<Path>(this){
            final /* synthetic */ KtTreeCompiler this$0;

            public final boolean test(Path it) {
                Path path = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                return KtTreeCompiler.access$isKotlinFile(this.this$0, path);
            }
            {
                this.this$0 = ktTreeCompiler;
            }
        }).filter(new Predicate<Path>(this){
            final /* synthetic */ KtTreeCompiler this$0;

            public final boolean test(Path it) {
                Path path = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                return KtTreeCompiler.access$notIgnored(this.this$0, path);
            }
            {
                this.this$0 = ktTreeCompiler;
            }
        }).map(new Function<T, R>(this, project){
            final /* synthetic */ KtTreeCompiler this$0;
            final /* synthetic */ Path $project;

            @NotNull
            public final KtFile apply(Path it) {
                KtCompiler ktCompiler = KtTreeCompiler.access$getCompiler$p(this.this$0);
                Path path = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                return ktCompiler.compile(this.$project, path);
            }
            {
                this.this$0 = ktTreeCompiler;
                this.$project = path;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"streamFor(project)\n\t\t\t.f\u2026er.compile(project, it) }");
        return JunkKt.toList(stream2);
    }

    private final boolean isKotlinFile(@NotNull Path $receiver) {
        String fullPath;
        String string = fullPath = ((Object)$receiver.toAbsolutePath()).toString();
        int n = StringsKt.lastIndexOf$default((CharSequence)fullPath, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String kotlinEnding = string3;
        return Intrinsics.areEqual((Object)kotlinEnding, (Object)"kt") || Intrinsics.areEqual((Object)kotlinEnding, (Object)"kts");
    }

    private final boolean notIgnored(Path path) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.filters;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PathFilter it = (PathFilter)element$iv;
                    if (!it.matches(path)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    public KtTreeCompiler(@NotNull KtCompiler compiler, @NotNull List<PathFilter> filters, boolean parallel, boolean debug) {
        Intrinsics.checkParameterIsNotNull((Object)compiler, (String)"compiler");
        Intrinsics.checkParameterIsNotNull(filters, (String)"filters");
        this.compiler = compiler;
        this.filters = filters;
        this.parallel = parallel;
        this.debug = debug;
    }

    public /* synthetic */ KtTreeCompiler(KtCompiler ktCompiler, List list, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ktCompiler = new KtCompiler();
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(ktCompiler, list, bl, bl2);
    }

    public KtTreeCompiler() {
        this(null, null, false, false, 15, null);
    }

    public static final /* synthetic */ boolean access$isKotlinFile(KtTreeCompiler $this, @NotNull Path $receiver) {
        return $this.isKotlinFile($receiver);
    }

    public static final /* synthetic */ boolean access$notIgnored(KtTreeCompiler $this, @NotNull Path path) {
        return $this.notIgnored(path);
    }

    @NotNull
    public static final /* synthetic */ KtCompiler access$getCompiler$p(KtTreeCompiler $this) {
        return $this.compiler;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler$Companion;", "", "()V", "instance", "Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler;", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "detekt-core"})
    public static final class Companion {
        @NotNull
        public final KtTreeCompiler instance(@NotNull ProcessingSettings settings) {
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            ProcessingSettings $receiver = settings;
            return new KtTreeCompiler(new KtCompiler(), $receiver.getPathFilters(), $receiver.getParallelCompilation(), false, 8, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

