/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.KtCompiler;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0005\u001a6\u0010\b\u001a\u00020\t*\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000e\u001a\u0012\u0010\u000f\u001a\u00020\t*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\u000b\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u0016\u001a@\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u000b0\u000e\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u0019*\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u000b0\u001a0\u000b\u00a8\u0006\u001b"}, d2={"absolutePath", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "exists", "", "Ljava/nio/file/Path;", "isDirectory", "isFile", "mergeSmells", "", "", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "other", "", "printStacktraceRecursively", "", "logger", "Ljava/io/PrintStream;", "relativePath", "toList", "T", "Ljava/util/stream/Stream;", "toMergedMap", "K", "V", "Lkotlin/Pair;", "detekt-core"})
public final class JunkKt {
    @NotNull
    public static final <T> List<T> toList(@NotNull Stream<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        List list = $receiver.collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"collect(Collectors.toList<T>())");
        return list;
    }

    public static final boolean exists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.exists($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    public static final boolean isDirectory(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    @Nullable
    public static final String relativePath(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return (String)$receiver.getUserData(KtCompiler.Companion.getRELATIVE_PATH());
    }

    @Nullable
    public static final String absolutePath(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return (String)$receiver.getUserData(KtCompiler.Companion.getABSOLUTE_PATH());
    }

    public static final void mergeSmells(@NotNull Map<String, List<Finding>> $receiver, @NotNull Map<String, ? extends List<? extends Finding>> other) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Iterator<Map.Entry<String, ? extends List<? extends Finding>>> iterator = other.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends List<? extends Finding>> entry;
            Map.Entry<String, ? extends List<? extends Finding>> entry2 = entry = iterator.next();
            String key = entry2.getKey();
            entry2 = entry;
            List<? extends Finding> findings = entry2.getValue();
            $receiver.merge(key, findings, mergeSmells.1.INSTANCE);
        }
    }

    public static final void printStacktraceRecursively(@NotNull Throwable $receiver, @NotNull PrintStream logger) {
        block1: {
            StackTraceElement[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            StackTraceElement[] stackTraceElementArray = $receiver.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"stackTrace");
            StackTraceElement[] stackTraceElementArray2 = $receiver$iv = stackTraceElementArray;
            int n = stackTraceElementArray2.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = stackTraceElementArray2[i];
                boolean bl = false;
                logger.println(it);
            }
            Throwable throwable = $receiver.getCause();
            if (throwable == null) break block1;
            JunkKt.printStacktraceRecursively(throwable, logger);
        }
    }

    @NotNull
    public static final <K, V> Map<K, List<V>> toMergedMap(@NotNull List<? extends Pair<? extends K, ? extends List<? extends V>>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        HashMap<Object, List> map2 = new HashMap<Object, List>();
        for (Pair<K, List<V>> pair : $receiver) {
            Object key = pair.component1();
            List values = (List)pair.component2();
            map2.merge(key, CollectionsKt.toMutableList((Collection)values), toMergedMap.1.INSTANCE);
        }
        return map2;
    }
}

