/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.api.ProjectExtensionKt;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtCompiler;", "", "()V", "psiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "getPsiFileFactory", "()Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "compile", "Lorg/jetbrains/kotlin/psi/KtFile;", "root", "Ljava/nio/file/Path;", "subPath", "createKtFile", "content", "", "path", "determineLineSeparator", "Companion", "detekt-core"})
public class KtCompiler {
    @NotNull
    private final PsiFileFactory psiFileFactory;
    @NotNull
    private static final Key<String> LINE_SEPARATOR;
    @NotNull
    private static final Key<String> RELATIVE_PATH;
    @NotNull
    private static final Key<String> ABSOLUTE_PATH;
    public static final Companion Companion;

    @NotNull
    protected final PsiFileFactory getPsiFileFactory() {
        return this.psiFileFactory;
    }

    @NotNull
    public final KtFile compile(@NotNull Path root, @NotNull Path subPath) {
        KtFile ktFile;
        KtFile ktFile2;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)subPath, (String)"subPath");
        boolean bl = JunkKt.isFile(subPath);
        if (!bl) {
            boolean bl2 = false;
            String string = "Given sub path should be a regular file!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path relativePath = (Intrinsics.areEqual((Object)root, (Object)subPath) ? subPath.getFileName() : root.getFileName().resolve(root.relativize(subPath))).normalize();
        Path absolutePath = (Intrinsics.areEqual((Object)root, (Object)subPath) ? subPath : subPath).toAbsolutePath().normalize();
        File file = subPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"subPath.toFile()");
        String content = FilesKt.readText$default((File)file, null, (int)1, null);
        String lineSeparator = this.determineLineSeparator(content);
        String string = StringUtilRt.convertLineSeparators((String)content);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtilRt.convertLineSeparators(content)");
        String normalizedContent = string;
        Path path = absolutePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"absolutePath");
        KtFile $receiver = ktFile2 = (ktFile = this.createKtFile(normalizedContent, path));
        boolean bl3 = false;
        $receiver.putUserData(LINE_SEPARATOR, (Object)lineSeparator);
        $receiver.putUserData(RELATIVE_PATH, (Object)((Object)relativePath).toString());
        $receiver.putUserData(ABSOLUTE_PATH, (Object)((Object)absolutePath).toString());
        return ktFile2;
    }

    private final KtFile createKtFile(String content, Path path) {
        PsiFile psiFile = this.psiFileFactory.createFileFromText(((Object)path.getFileName()).toString(), (Language)KotlinLanguage.INSTANCE, (CharSequence)StringUtilRt.convertLineSeparators((String)content), true, true, false, (VirtualFile)new LightVirtualFile(((Object)path).toString()));
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            throw (Throwable)new IllegalStateException("kotlin file expected");
        }
        return ktFile;
    }

    private final String determineLineSeparator(@NotNull String $receiver) {
        int i = StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'\n', (int)0, (boolean)false, (int)6, null);
        if (i == -1) {
            String string;
            if (StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'\r', (int)0, (boolean)false, (int)6, null) == -1) {
                String string2 = System.getProperty("line.separator");
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"System.getProperty(\"line.separator\")");
            } else {
                string = "\r";
            }
            return string;
        }
        return i != 0 && $receiver.charAt(i) == '\r' ? "\r\n" : "\n";
    }

    public KtCompiler() {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)ProjectExtensionKt.getPsiProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFileFactory, (String)"PsiFileFactory.getInstance(psiProject)");
        this.psiFileFactory = psiFileFactory;
    }

    static {
        Companion = new Companion(null);
        LINE_SEPARATOR = new Key("lineSeparator");
        RELATIVE_PATH = new Key("relativePath");
        ABSOLUTE_PATH = new Key("absolutePath");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtCompiler$Companion;", "", "()V", "ABSOLUTE_PATH", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Key;", "", "getABSOLUTE_PATH", "()Lorg/jetbrains/kotlin/com/intellij/openapi/util/Key;", "LINE_SEPARATOR", "getLINE_SEPARATOR", "RELATIVE_PATH", "getRELATIVE_PATH", "detekt-core"})
    public static final class Companion {
        @NotNull
        public final Key<String> getLINE_SEPARATOR() {
            return LINE_SEPARATOR;
        }

        @NotNull
        public final Key<String> getRELATIVE_PATH() {
            return RELATIVE_PATH;
        }

        @NotNull
        public final Key<String> getABSOLUTE_PATH() {
            return ABSOLUTE_PATH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

