/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.KtCompiler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0005\u001a6\u0010\b\u001a\u00020\t*\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u000b\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0012\u00a8\u0006\u0013"}, d2={"absolutePath", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "exists", "", "Ljava/nio/file/Path;", "isDirectory", "isFile", "mergeSmells", "", "", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "other", "", "relativePath", "toList", "T", "Ljava/util/stream/Stream;", "detekt-core"})
public final class JunkKt {
    @NotNull
    public static final <T> List<T> toList(@NotNull Stream<T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        List list = $receiver.collect(Collectors.toList());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"collect(Collectors.toList<T>())");
        return list;
    }

    public static final boolean exists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.exists($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    public static final boolean isDirectory(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    @Nullable
    public static final String relativePath(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (String)$receiver.getUserData(KtCompiler.Companion.getRELATIVE_PATH());
    }

    @Nullable
    public static final String absolutePath(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (String)$receiver.getUserData(KtCompiler.Companion.getABSOLUTE_PATH());
    }

    public static final void mergeSmells(@NotNull Map<String, List<Finding>> $receiver, @NotNull Map<String, ? extends List<? extends Finding>> other) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        Iterator<Map.Entry<String, ? extends List<? extends Finding>>> iterator = other.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends List<? extends Finding>> entry;
            Map.Entry<String, ? extends List<? extends Finding>> entry2 = entry = iterator.next();
            String key = entry2.getKey();
            entry2 = entry;
            List<? extends Finding> findings = entry2.getValue();
            $receiver.merge(key, findings, mergeSmells.1.INSTANCE);
        }
    }
}

