/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import java.nio.file.Path;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/core/PathFilter;", "", "pattern", "", "(Ljava/lang/String;)V", "regex", "Lkotlin/text/Regex;", "matches", "", "path", "Ljava/nio/file/Path;", "Companion", "detekt-core"})
public final class PathFilter {
    private final Regex regex;
    private static final boolean IS_WINDOWS;
    public static final Companion Companion;

    public final boolean matches(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        CharSequence charSequence = ((Object)path.toAbsolutePath()).toString();
        Regex regex = this.regex;
        return regex.matches(charSequence);
    }

    public PathFilter(@NotNull String pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        try {
            String independentPattern = IS_WINDOWS ? StringsKt.replace$default((String)pattern, (String)"/", (String)"\\\\", (boolean)false, (int)4, null) : pattern;
            this.regex = new Regex(independentPattern);
        }
        catch (PatternSyntaxException exception) {
            throw (Throwable)new IllegalArgumentException("Provided regex is not valid: " + pattern);
        }
    }

    static {
        Companion = new Companion(null);
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        IS_WINDOWS = StringsKt.contains$default((CharSequence)string, (CharSequence)"Windows", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/core/PathFilter$Companion;", "", "()V", "IS_WINDOWS", "", "getIS_WINDOWS", "()Z", "detekt-core"})
    public static final class Companion {
        public final boolean getIS_WINDOWS() {
            return IS_WINDOWS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

