/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.github.detekt.psi.KeysKt;
import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.core.ModificationNotification;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtFileModifier;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "()V", "onFinish", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "unnormalizeContent", "", "detekt-core"})
public final class KtFileModifier
implements FileProcessListener {
    /*
     * WARNING - void declaration
     */
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result2) {
        void $this$mapTo$iv$iv;
        KtFile it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getModificationStamp() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)KtFilesKt.absolutePath((PsiFile)((PsiFile)it)), (Object)this.unnormalizeContent(it));
            collection.add(pair);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] byArray;
            Pair it2 = (Pair)element$iv;
            boolean bl = false;
            result2.add((Notification)new ModificationNotification((Path)it2.getFirst()));
            String string = (String)it2.getSecond();
            Path path = (Path)it2.getFirst();
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
            Files.write(path, byArray, new OpenOption[0]);
        }
    }

    private final String unnormalizeContent(@NotNull KtFile $this$unnormalizeContent) {
        String lineSeparator = (String)$this$unnormalizeContent.getUserData(KeysKt.getLINE_SEPARATOR());
        boolean bl = lineSeparator != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "No line separator entry for ktFile " + JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)$this$unnormalizeContent).asString();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = StringUtilRt.convertLineSeparators((String)$this$unnormalizeContent.getText(), (String)lineSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtilRt.convertLine\u2026tors(text, lineSeparator)");
        return string;
    }

    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        FileProcessListener.DefaultImpls.onFinish((FileProcessListener)this, files, (Detektion)result2, (BindingContext)bindingContext2);
    }

    @NotNull
    public String getId() {
        return FileProcessListener.DefaultImpls.getId((FileProcessListener)this);
    }

    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority((FileProcessListener)this);
    }

    public void init(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (Config)config);
    }

    public void init(@NotNull SetupContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (SetupContext)context);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="onProcess(file, bindingContext)"), message="Use alternative with a binding context.")
    public void onProcess(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        FileProcessListener.DefaultImpls.onProcess((FileProcessListener)this, (KtFile)file);
    }

    public void onProcess(@NotNull KtFile file, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        FileProcessListener.DefaultImpls.onProcess((FileProcessListener)this, (KtFile)file, (BindingContext)bindingContext2);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="onProcessComplete(file, findings, bindingContext)"), message="Use alternative with a binding context.")
    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(findings, (String)"findings");
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings);
    }

    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(findings, (String)"findings");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings, (BindingContext)bindingContext2);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="onStart(files, bindingContext)"), message="Use alternative with a binding context.")
    public void onStart(@NotNull List<? extends KtFile> files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files);
    }

    public void onStart(@NotNull List<? extends KtFile> files, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files, (BindingContext)bindingContext2);
    }
}

