/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.settings;

import io.github.detekt.tooling.api.spec.LoggingSpec;
import io.gitlab.arturbosch.detekt.core.settings.LoggingAware;
import io.gitlab.arturbosch.detekt.core.settings.LoggingAwareKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0012H\u0016R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/core/settings/LoggingFacade;", "Lio/gitlab/arturbosch/detekt/core/settings/LoggingAware;", "spec", "Lio/github/detekt/tooling/api/spec/LoggingSpec;", "(Lio/github/detekt/tooling/api/spec/LoggingSpec;)V", "errorChannel", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "getErrorChannel", "()Ljava/lang/Appendable;", "outputChannel", "getOutputChannel", "getSpec", "()Lio/github/detekt/tooling/api/spec/LoggingSpec;", "debug", "", "msg", "Lkotlin/Function0;", "", "error", "", "info", "detekt-core"})
public final class LoggingFacade
implements LoggingAware {
    @NotNull
    private final Appendable outputChannel;
    @NotNull
    private final Appendable errorChannel;
    @NotNull
    private final LoggingSpec spec;

    @Override
    @NotNull
    public Appendable getOutputChannel() {
        return this.outputChannel;
    }

    @Override
    @NotNull
    public Appendable getErrorChannel() {
        return this.errorChannel;
    }

    @Override
    public void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Appendable appendable = this.getOutputChannel();
        boolean bl = false;
        Appendable appendable2 = appendable.append(msg);
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
        Appendable appendable3 = appendable2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append('\\n')");
    }

    @Override
    public void error(@NotNull String msg, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Appendable appendable = this.getErrorChannel();
        boolean bl = false;
        Appendable appendable2 = appendable.append(msg);
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
        Appendable appendable3 = appendable2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append('\\n')");
        LoggingAwareKt.printStacktraceRecursively(error, this.getErrorChannel());
    }

    @Override
    public void debug(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (this.spec.getDebug()) {
            Appendable appendable = this.getOutputChannel();
            CharSequence charSequence = (CharSequence)msg.invoke();
            boolean bl = false;
            Appendable appendable2 = appendable.append(charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
            Appendable appendable3 = appendable2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append('\\n')");
        }
    }

    @NotNull
    public final LoggingSpec getSpec() {
        return this.spec;
    }

    public LoggingFacade(@NotNull LoggingSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = spec;
        this.outputChannel = this.spec.getOutputChannel();
        this.errorChannel = this.spec.getErrorChannel();
    }
}

