/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.reporting;

import io.github.detekt.tooling.api.spec.ReportsSpec;
import io.gitlab.arturbosch.detekt.api.ConsoleReport;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.OutputReport;
import io.gitlab.arturbosch.detekt.api.PropertiesAware;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.reporting.ConsoleReportLocator;
import io.gitlab.arturbosch.detekt.core.reporting.OutputReportLocator;
import io.gitlab.arturbosch.detekt.core.reporting.ReportingKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/core/reporting/OutputFacade;", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "(Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;)V", "reports", "", "", "Lio/github/detekt/tooling/api/spec/ReportsSpec$Report;", "handleConsoleReports", "", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "handleOutputReports", "run", "detekt-core"})
public final class OutputFacade {
    @NotNull
    private final ProcessingSettings settings;
    @NotNull
    private Map<String, ? extends ReportsSpec.Report> reports;

    /*
     * WARNING - void declaration
     */
    public OutputFacade(@NotNull ProcessingSettings settings2) {
        Map map;
        Collection collection;
        Collection collection2;
        Iterable $this$getOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        this.settings = settings2;
        OutputFacade outputFacade = this;
        PropertiesAware propertiesAware = this.settings;
        String key$iv = "detekt.output.report.paths.key";
        boolean $i$f$getOrNull = false;
        Object value$iv = $this$getOrNull$iv.getProperties().get(key$iv);
        if (value$iv != null) {
            Object object;
            Object $this$safeAs$iv$iv = value$iv;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv$iv;
            if (!(object2 instanceof Collection)) {
                object2 = null;
            }
            if ((object = (Collection)object2) == null) {
                $this$safeAs$iv$iv = "No value of type ''" + Reflection.getOrCreateKotlinClass(Collection.class) + " for key '" + key$iv + "'.";
                $i$f$safeAs = false;
                throw (Throwable)new IllegalStateException($this$safeAs$iv$iv.toString());
            }
            collection2 = object;
        } else {
            collection2 = collection = null;
        }
        if (collection == null) {
            map = null;
        } else {
            Map map2;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            $this$getOrNull$iv = collection;
            OutputFacade outputFacade2 = outputFacade;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            value$iv = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ReportsSpec.Report report = (ReportsSpec.Report)element$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getType();
                map2.put(string, element$iv$iv);
            }
            map2 = destination$iv$iv;
            outputFacade = outputFacade2;
            map = map2;
        }
        Map map3 = map;
        outputFacade.reports = map3 == null ? MapsKt.emptyMap() : map3;
    }

    public final void run(@NotNull Detektion result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.handleOutputReports(result2);
        this.handleConsoleReports(result2);
    }

    private final void handleConsoleReports(Detektion result2) {
        List extensions = new ConsoleReportLocator(this.settings).load();
        for (ConsoleReport extension : extensions) {
            Appendable appendable;
            String output = extension.render(result2);
            Object object = output;
            boolean bl = false;
            boolean bl2 = false;
            if (object == null || StringsKt.isBlank((CharSequence)object)) continue;
            object = this.settings.getOutputChannel();
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)object.append(output), (String)"append(value)");
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
        }
    }

    private final void handleOutputReports(Detektion result2) {
        List extensions = new OutputReportLocator(this.settings).load();
        for (OutputReport report : extensions) {
            ReportsSpec.Report report2 = this.reports.get(ReportingKt.defaultReportMapping(report.getId()));
            Path filePath = report2 == null ? null : report2.getPath();
            if (filePath == null) continue;
            report.write(filePath, result2);
            result2.add((Notification)new SimpleNotification("Successfully generated " + report.getName() + " at " + filePath, null, 2, null));
        }
    }
}

