/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.reporting;

import io.github.detekt.report.html.HtmlOutputReport;
import io.github.detekt.report.sarif.SarifOutputReport;
import io.github.detekt.report.txt.TxtOutputReport;
import io.github.detekt.report.xml.XmlOutputReport;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.CorrectableCodeSmell;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.core.reporting.ColorizerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\"\u0010\u0007\u001a\u00020\u00012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0000\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a(\u0010\u000f\u001a\u0018\u0012\b\u0012\u00060\u0001j\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e\u001a(\u0010\u0013\u001a\u0018\u0012\b\u0012\u00060\u0001j\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"BUILD", "", "DETEKT_OUTPUT_REPORT_BASE_PATH_KEY", "DETEKT_OUTPUT_REPORT_PATHS_KEY", "EXCLUDE_CORRECTABLE", "defaultReportMapping", "reportId", "printFindings", "findings", "", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "excludeCorrectable", "", "Lio/gitlab/arturbosch/detekt/api/Config;", "filterAutoCorrectedIssues", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "config", "filterEmptyIssues", "detekt-core"})
public final class ReportingKt {
    @NotNull
    public static final String BUILD = "build";
    @NotNull
    public static final String EXCLUDE_CORRECTABLE = "excludeCorrectable";
    @NotNull
    public static final String DETEKT_OUTPUT_REPORT_PATHS_KEY = "detekt.output.report.paths.key";
    @NotNull
    public static final String DETEKT_OUTPUT_REPORT_BASE_PATH_KEY = "detekt.output.report.base.path";

    @NotNull
    public static final String defaultReportMapping(@NotNull String reportId) {
        Intrinsics.checkNotNullParameter((Object)reportId, (String)"reportId");
        String string = reportId;
        return Intrinsics.areEqual((Object)string, (Object)TxtOutputReport.class.getSimpleName()) ? "txt" : (Intrinsics.areEqual((Object)string, (Object)XmlOutputReport.class.getSimpleName()) ? "xml" : (Intrinsics.areEqual((Object)string, (Object)HtmlOutputReport.class.getSimpleName()) ? "html" : (Intrinsics.areEqual((Object)string, (Object)SarifOutputReport.class.getSimpleName()) ? "sarif" : reportId)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String printFindings(@NotNull Map<String, ? extends List<? extends Finding>> findings) {
        Debt element$iv;
        Intrinsics.checkNotNullParameter(findings, (String)"findings");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$printFindings_u24lambda_u2d5 = stringBuilder;
        boolean bl5 = false;
        boolean bl6 = false;
        List debtList = new ArrayList();
        Map<String, ? extends List<? extends Finding>> $this$forEach$iv = findings;
        boolean $i$f$forEach = false;
        Map<String, ? extends List<? extends Finding>> map = $this$forEach$iv;
        boolean bl7 = false;
        Iterator<Map.Entry<String, ? extends List<? extends Finding>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Debt $dstr$key$issues = element$iv = iterator.next();
            boolean bl8 = false;
            Debt debt = $dstr$key$issues;
            boolean bl9 = false;
            String key = debt.getKey();
            Debt debt2 = $dstr$key$issues;
            boolean bl10 = false;
            List<? extends Finding> issues = debt2.getValue();
            Iterable iterable = issues;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Finding finding = (Finding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl11 = false;
                Debt debt3 = it.getIssue().getDebt();
                collection.add(debt3);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void d;
                Debt $i$f$mapTo2 = (Debt)iterator$iv.next();
                Debt acc = (Debt)accumulator$iv;
                boolean bl12 = false;
                accumulator$iv = acc.plus((Debt)d);
            }
            Debt debt4 = (Debt)accumulator$iv;
            debtList.add(debt4);
            $this$printFindings_u24lambda_u2d5.append(key + " - " + debt4 + " debt\n");
            Iterable $this$forEach$iv2 = issues;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Finding it = (Finding)element$iv2;
                boolean bl13 = false;
                $this$printFindings_u24lambda_u2d5.append("\t");
                $this$printFindings_u24lambda_u2d5.append(ColorizerKt.yellow(it.compact()));
                $this$printFindings_u24lambda_u2d5.append("\n");
            }
        }
        Iterable $this$reduce$iv = debtList;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void d;
            element$iv = (Debt)iterator$iv.next();
            Debt acc = (Debt)accumulator$iv;
            boolean bl14 = false;
            accumulator$iv = acc.plus((Debt)d);
        }
        Debt overallDebt = (Debt)accumulator$iv;
        $this$printFindings_u24lambda_u2d5.append("\nOverall debt: " + overallDebt + '\n');
        $this$printFindings_u24lambda_u2d5.toString();
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final boolean excludeCorrectable(@NotNull Config $this$excludeCorrectable) {
        Intrinsics.checkNotNullParameter((Object)$this$excludeCorrectable, (String)"<this>");
        return (Boolean)$this$excludeCorrectable.subConfig(BUILD).valueOrDefault(EXCLUDE_CORRECTABLE, (Object)false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<Finding>> filterEmptyIssues(@NotNull Detektion $this$filterEmptyIssues, @NotNull Config config) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$filterEmptyIssues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Map<String, List<Finding>> $this$filter$iv = ReportingKt.filterAutoCorrectedIssues($this$filterEmptyIssues, config);
        boolean $i$f$filter = false;
        Map<String, List<Finding>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Collection collection = (Collection)it.getValue();
            boolean bl3 = false;
            boolean bl4 = !collection.isEmpty();
            if (!bl4) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<Finding>> filterAutoCorrectedIssues(@NotNull Detektion $this$filterAutoCorrectedIssues, @NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)$this$filterAutoCorrectedIssues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!ReportingKt.excludeCorrectable(config)) {
            return $this$filterAutoCorrectedIssues.getFindings();
        }
        HashMap filteredFindings = new HashMap();
        Map $this$forEach$iv = $this$filterAutoCorrectedIssues.getFindings();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry $dstr$ruleSetId$findingsList = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$ruleSetId$findingsList;
            boolean bl3 = false;
            String ruleSetId = (String)entry.getKey();
            Map.Entry entry2 = $dstr$ruleSetId$findingsList;
            boolean bl4 = false;
            List findingsList = (List)entry2.getValue();
            Iterable $this$filter$iv = findingsList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Finding finding = (Finding)element$iv$iv;
                boolean bl5 = false;
                CorrectableCodeSmell correctableCodeSmell = finding instanceof CorrectableCodeSmell ? (CorrectableCodeSmell)finding : null;
                if (!(correctableCodeSmell == null || !correctableCodeSmell.getAutoCorrectEnabled())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newFindingsList = (List)destination$iv$iv;
            Map map2 = filteredFindings;
            boolean bl6 = false;
            map2.put(ruleSetId, newFindingsList);
        }
        return filteredFindings;
    }
}

