/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.github.detekt.psi.KeysKt;
import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.FileProcessListener;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.core.ModificationNotification;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtFileModifier;", "Lio/gitlab/arturbosch/detekt/api/FileProcessListener;", "()V", "onFinish", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "unnormalizeContent", "", "detekt-core"})
public final class KtFileModifier
implements FileProcessListener {
    /*
     * WARNING - void declaration
     */
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result2, @NotNull BindingContext bindingContext2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        KtFile it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getModificationStamp() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)KtFilesKt.absolutePath((PsiFile)((PsiFile)it)), (Object)this.unnormalizeContent(it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it2 = (Pair)element$iv;
            boolean bl = false;
            result2.add((Notification)new ModificationNotification((Path)it2.getFirst()));
            Path path = (Path)it2.getFirst();
            String string = (String)it2.getSecond();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Files.write(path, byArray, new OpenOption[0]);
        }
    }

    private final String unnormalizeContent(KtFile $this$unnormalizeContent) {
        String lineSeparator = (String)$this$unnormalizeContent.getUserData(KeysKt.getLINE_SEPARATOR());
        if (lineSeparator == null) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"No line separator entry for ktFile ", (Object)JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)$this$unnormalizeContent).asString());
            throw new IllegalArgumentException(string.toString());
        }
        String string = StringUtilRt.convertLineSeparators((String)$this$unnormalizeContent.getText(), (String)lineSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(text, lineSeparator)");
        return string;
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onFinish(files, result, bindingContext)", imports={}))
    public void onFinish(@NotNull List<? extends KtFile> files, @NotNull Detektion result2) {
        FileProcessListener.DefaultImpls.onFinish((FileProcessListener)this, files, (Detektion)result2);
    }

    @NotNull
    public String getId() {
        return FileProcessListener.DefaultImpls.getId((FileProcessListener)this);
    }

    public int getPriority() {
        return FileProcessListener.DefaultImpls.getPriority((FileProcessListener)this);
    }

    public void init(@NotNull Config config) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (Config)config);
    }

    public void init(@NotNull SetupContext context) {
        FileProcessListener.DefaultImpls.init((FileProcessListener)this, (SetupContext)context);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcess(file, bindingContext)", imports={}))
    public void onProcess(@NotNull KtFile file) {
        FileProcessListener.DefaultImpls.onProcess((FileProcessListener)this, (KtFile)file);
    }

    public void onProcess(@NotNull KtFile file, @NotNull BindingContext bindingContext2) {
        FileProcessListener.DefaultImpls.onProcess((FileProcessListener)this, (KtFile)file, (BindingContext)bindingContext2);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onProcessComplete(file, findings, bindingContext)", imports={}))
    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings);
    }

    public void onProcessComplete(@NotNull KtFile file, @NotNull Map<String, ? extends List<? extends Finding>> findings, @NotNull BindingContext bindingContext2) {
        FileProcessListener.DefaultImpls.onProcessComplete((FileProcessListener)this, (KtFile)file, findings, (BindingContext)bindingContext2);
    }

    @Deprecated(message="Use alternative with a binding context.", replaceWith=@ReplaceWith(expression="onStart(files, bindingContext)", imports={}))
    public void onStart(@NotNull List<? extends KtFile> files) {
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files);
    }

    public void onStart(@NotNull List<? extends KtFile> files, @NotNull BindingContext bindingContext2) {
        FileProcessListener.DefaultImpls.onStart((FileProcessListener)this, files, (BindingContext)bindingContext2);
    }
}

