/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.tooling;

import io.github.detekt.tooling.api.AnalysisResult;
import io.github.detekt.tooling.api.Detekt;
import io.github.detekt.tooling.api.DetektError;
import io.github.detekt.tooling.api.InvalidConfig;
import io.github.detekt.tooling.api.MaxIssuesReached;
import io.github.detekt.tooling.api.UnexpectedError;
import io.github.detekt.tooling.api.spec.ProcessingSpec;
import io.github.detekt.tooling.internal.DefaultAnalysisResult;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.config.IssueExtensionKt;
import io.gitlab.arturbosch.detekt.core.config.MaxIssueCheck;
import io.gitlab.arturbosch.detekt.core.tooling.DefaultConfigProviderKt;
import io.gitlab.arturbosch.detekt.core.tooling.DefaultLifecycle;
import io.gitlab.arturbosch.detekt.core.tooling.Lifecycle;
import io.gitlab.arturbosch.detekt.core.tooling.ParsingStrategyKt;
import io.gitlab.arturbosch.detekt.core.tooling.ProcessingSpecSettingsBridgeKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J!\u0010\u0017\u001a\u00020\f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/core/tooling/AnalysisFacade;", "Lio/github/detekt/tooling/api/Detekt;", "spec", "Lio/github/detekt/tooling/api/spec/ProcessingSpec;", "(Lio/github/detekt/tooling/api/spec/ProcessingSpec;)V", "checkMaxIssuesReachedReturningErrors", "Lio/github/detekt/tooling/api/DetektError;", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "run", "Lio/github/detekt/tooling/api/AnalysisResult;", "path", "Ljava/nio/file/Path;", "sourceCode", "", "filename", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "runAnalysis", "createLifecycle", "Lkotlin/Function1;", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "Lio/gitlab/arturbosch/detekt/core/tooling/Lifecycle;", "runAnalysis$detekt_core", "detekt-core"})
public final class AnalysisFacade
implements Detekt {
    @NotNull
    private final ProcessingSpec spec;

    public AnalysisFacade(@NotNull ProcessingSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = spec;
    }

    @NotNull
    public AnalysisResult run() {
        return this.runAnalysis$detekt_core((Function1<? super ProcessingSettings, ? extends Lifecycle>)((Function1)new Function1<ProcessingSettings, Lifecycle>(this){
            final /* synthetic */ AnalysisFacade this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Lifecycle invoke(@NotNull ProcessingSettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new DefaultLifecycle(DefaultConfigProviderKt.getDefaultConfiguration(AnalysisFacade.access$getSpec$p(this.this$0)), it, ParsingStrategyKt.getInputPathsToKtFiles(), null, null, null, 56, null);
            }
        }));
    }

    @NotNull
    public AnalysisResult run(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.runAnalysis$detekt_core((Function1<? super ProcessingSettings, ? extends Lifecycle>)((Function1)new Function1<ProcessingSettings, Lifecycle>(this, path){
            final /* synthetic */ AnalysisFacade this$0;
            final /* synthetic */ Path $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(1);
            }

            @NotNull
            public final Lifecycle invoke(@NotNull ProcessingSettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new DefaultLifecycle(DefaultConfigProviderKt.getDefaultConfiguration(AnalysisFacade.access$getSpec$p(this.this$0)), it, ParsingStrategyKt.pathToKtFile(this.$path), null, null, null, 56, null);
            }
        }));
    }

    @NotNull
    public AnalysisResult run(@NotNull String sourceCode, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.runAnalysis$detekt_core((Function1<? super ProcessingSettings, ? extends Lifecycle>)((Function1)new Function1<ProcessingSettings, Lifecycle>(this, sourceCode, filename){
            final /* synthetic */ AnalysisFacade this$0;
            final /* synthetic */ String $sourceCode;
            final /* synthetic */ String $filename;
            {
                this.this$0 = $receiver;
                this.$sourceCode = $sourceCode;
                this.$filename = $filename;
                super(1);
            }

            @NotNull
            public final Lifecycle invoke(@NotNull ProcessingSettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Config config = DefaultConfigProviderKt.getDefaultConfiguration(AnalysisFacade.access$getSpec$p(this.this$0));
                Path path = Paths.get(this.$filename, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(filename)");
                return new DefaultLifecycle(config, it, ParsingStrategyKt.contentToKtFile(this.$sourceCode, path), null, null, null, 56, null);
            }
        }));
    }

    @NotNull
    public AnalysisResult run(@NotNull Collection<? extends KtFile> files, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        return this.runAnalysis$detekt_core((Function1<? super ProcessingSettings, ? extends Lifecycle>)((Function1)new Function1<ProcessingSettings, Lifecycle>(this, files, bindingContext2){
            final /* synthetic */ AnalysisFacade this$0;
            final /* synthetic */ Collection<KtFile> $files;
            final /* synthetic */ BindingContext $bindingContext;
            {
                this.this$0 = $receiver;
                this.$files = $files;
                this.$bindingContext = $bindingContext;
                super(1);
            }

            @NotNull
            public final Lifecycle invoke(@NotNull ProcessingSettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new DefaultLifecycle(DefaultConfigProviderKt.getDefaultConfiguration(AnalysisFacade.access$getSpec$p(this.this$0)), it, (Function1)new Function1<ProcessingSettings, List<? extends KtFile>>(this.$files){
                    final /* synthetic */ Collection<KtFile> $files;
                    {
                        this.$files = $files;
                        super(1);
                    }

                    @NotNull
                    public final List<KtFile> invoke(@NotNull ProcessingSettings it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CollectionsKt.toList((Iterable)this.$files);
                    }
                }, (Function1)new Function1<List<? extends KtFile>, BindingContext>(this.$bindingContext){
                    final /* synthetic */ BindingContext $bindingContext;
                    {
                        this.$bindingContext = $bindingContext;
                        super(1);
                    }

                    @NotNull
                    public final BindingContext invoke(@NotNull List<? extends KtFile> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return this.$bindingContext;
                    }
                }, null, null, 48, null);
            }
        }));
    }

    @NotNull
    public final AnalysisResult runAnalysis$detekt_core(@NotNull Function1<? super ProcessingSettings, ? extends Lifecycle> createLifecycle) {
        Intrinsics.checkNotNullParameter(createLifecycle, (String)"createLifecycle");
        return (AnalysisResult)ProcessingSpecSettingsBridgeKt.withSettings(this.spec, (Function1)new Function1<ProcessingSettings, DefaultAnalysisResult>(this, createLifecycle){
            final /* synthetic */ AnalysisFacade this$0;
            final /* synthetic */ Function1<ProcessingSettings, Lifecycle> $createLifecycle;
            {
                this.this$0 = $receiver;
                this.$createLifecycle = $createLifecycle;
                super(1);
            }

            @NotNull
            public final DefaultAnalysisResult invoke(@NotNull ProcessingSettings $this$withSettings) {
                DefaultAnalysisResult defaultAnalysisResult;
                Object object;
                Intrinsics.checkNotNullParameter((Object)$this$withSettings, (String)"$this$withSettings");
                ProcessingSettings processingSettings = $this$withSettings;
                Function1<ProcessingSettings, Lifecycle> function1 = this.$createLifecycle;
                try {
                    ProcessingSettings $this$invoke_u24lambda_u2d0 = processingSettings;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)((Lifecycle)function1.invoke((Object)$this$invoke_u24lambda_u2d0)).analyze());
                }
                catch (Throwable $this$invoke_u24lambda_u2d0) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$invoke_u24lambda_u2d0));
                }
                Object result2 = object;
                Throwable error = Result.exceptionOrNull-impl((Object)result2);
                if (error == null) {
                    Object object2 = Result.isFailure-impl((Object)result2) ? null : result2;
                    if (object2 == null) {
                        boolean bl = false;
                        String string = "Result should not be null at this point.";
                        throw new IllegalStateException(string.toString());
                    }
                    Detektion container = (Detektion)object2;
                    defaultAnalysisResult = new DefaultAnalysisResult(container, AnalysisFacade.access$checkMaxIssuesReachedReturningErrors(this.this$0, container, $this$withSettings.getConfig()));
                } else {
                    defaultAnalysisResult = error instanceof InvalidConfig ? new DefaultAnalysisResult(null, (DetektError)error) : new DefaultAnalysisResult(null, (DetektError)new UnexpectedError(error));
                }
                return defaultAnalysisResult;
            }
        });
    }

    private final DetektError checkMaxIssuesReachedReturningErrors(Detektion result2, Config config) {
        Object object;
        if (this.spec.getBaselineSpec().getShouldCreateDuringAnalysis()) {
            return null;
        }
        AnalysisFacade analysisFacade = this;
        try {
            AnalysisFacade $this$checkMaxIssuesReachedReturningErrors_u24lambda_u2d0 = analysisFacade;
            boolean bl = false;
            int amount = IssueExtensionKt.getOrComputeWeightedAmountOfIssues(result2, config);
            new MaxIssueCheck($this$checkMaxIssuesReachedReturningErrors_u24lambda_u2d0.spec.getRulesSpec(), config).check(amount);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable error = Result.exceptionOrNull-impl((Object)object);
        return error instanceof MaxIssuesReached ? (DetektError)error : (error != null ? (DetektError)new UnexpectedError(error) : null);
    }

    public static final /* synthetic */ ProcessingSpec access$getSpec$p(AnalysisFacade $this) {
        return $this.spec;
    }

    public static final /* synthetic */ DetektError access$checkMaxIssuesReachedReturningErrors(AnalysisFacade $this, Detektion result2, Config config) {
        return $this.checkMaxIssuesReachedReturningErrors(result2, config);
    }
}

