/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.github.detekt.parser.KtCompiler;
import io.github.detekt.tooling.api.spec.ProjectSpec;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.TaskPool;
import io.gitlab.arturbosch.detekt.core.TaskPoolKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\nH\u0002J\f\u0010\u0015\u001a\u00020\u0014*\u00020\nH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler;", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "projectSpec", "Lio/github/detekt/tooling/api/spec/ProjectSpec;", "compiler", "Lio/github/detekt/parser/KtCompiler;", "(Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;Lio/github/detekt/tooling/api/spec/ProjectSpec;Lio/github/detekt/parser/KtCompiler;)V", "basePath", "Ljava/nio/file/Path;", "pathFilters", "Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "compile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "path", "compileProject", "project", "isIgnored", "", "isKotlinFile", "Companion", "detekt-core"})
public final class KtTreeCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessingSettings settings;
    @NotNull
    private final KtCompiler compiler;
    @Nullable
    private final Path basePath;
    @Nullable
    private final PathFilters pathFilters;
    @NotNull
    private static final Set<String> KT_ENDINGS;

    public KtTreeCompiler(@NotNull ProcessingSettings settings2, @NotNull ProjectSpec projectSpec, @NotNull KtCompiler compiler) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)projectSpec, (String)"projectSpec");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        this.settings = settings2;
        this.compiler = compiler;
        this.basePath = projectSpec.getBasePath();
        this.pathFilters = PathFilters.Companion.of(CollectionsKt.toList((Iterable)projectSpec.getIncludes()), CollectionsKt.toList((Iterable)projectSpec.getExcludes()));
    }

    public /* synthetic */ KtTreeCompiler(ProcessingSettings processingSettings, ProjectSpec projectSpec, KtCompiler ktCompiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ktCompiler = new KtCompiler(processingSettings.getEnvironment());
        }
        this(processingSettings, projectSpec, ktCompiler);
    }

    @NotNull
    public final List<KtFile> compile(@NotNull Path path) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.exists(path, new LinkOption[0])) {
            boolean bl = false;
            String string = "Given path " + path + " does not exist!";
            throw new IllegalArgumentException(string.toString());
        }
        if (JunkKt.isFile(path) && this.isKotlinFile(path)) {
            list = CollectionsKt.listOf((Object)this.compiler.compile(this.basePath, path));
        } else if (JunkKt.isDirectory(path)) {
            list = this.compileProject(path);
        } else {
            this.settings.debug((Function0<String>)((Function0)new Function0<String>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"Ignoring a file detekt cannot handle: ", (Object)this.$path);
                }
            }));
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<KtFile> compileProject(Path project) {
        Stream<Path> kotlinFiles = Files.walk(project, new FileVisitOption[0]).filter(JunkKt::isFile).filter(arg_0 -> KtTreeCompiler.compileProject$lambda-1(this, arg_0)).filter(arg_0 -> KtTreeCompiler.compileProject$lambda-2(this, arg_0));
        if (this.settings.getSpec().getExecutionSpec().getParallelParsing()) {
            TaskPool service = this.settings.getTaskPool();
            List tasks2 = kotlinFiles.map(arg_0 -> KtTreeCompiler.compileProject$lambda-3(service, this, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(tasks2, (String)"tasks");
            return CollectionsKt.filterNotNull((Iterable)TaskPoolKt.awaitAll(tasks2));
        }
        List<KtFile> list = kotlinFiles.map(arg_0 -> KtTreeCompiler.compileProject$lambda-4(this, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"{\n            kotlinFile\u2026ctors.toList())\n        }");
        return list;
    }

    private final boolean isKotlinFile(Path $this$isKotlinFile) {
        String fullPath = ((Object)$this$isKotlinFile.toAbsolutePath()).toString();
        String string = fullPath.substring(StringsKt.lastIndexOf$default((CharSequence)fullPath, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String kotlinEnding = string;
        return KT_ENDINGS.contains(kotlinEnding);
    }

    private final boolean isIgnored(Path path) {
        Boolean ignored;
        PathFilters pathFilters = this.pathFilters;
        Boolean bl = ignored = pathFilters == null ? null : Boolean.valueOf(pathFilters.isIgnored(path));
        if (Intrinsics.areEqual((Object)ignored, (Object)true)) {
            this.settings.debug((Function0<String>)((Function0)new Function0<String>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Ignoring file '" + this.$path + '\'';
                }
            }));
        }
        Boolean bl2 = ignored;
        return bl2 == null ? false : bl2;
    }

    private static final boolean compileProject$lambda-1(KtTreeCompiler this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.isKotlinFile(it);
    }

    private static final boolean compileProject$lambda-2(KtTreeCompiler this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return !this$0.isIgnored(it);
    }

    private static final CompletableFuture compileProject$lambda-3(TaskPool $service, KtTreeCompiler this$0, Path path) {
        Intrinsics.checkNotNullParameter((Object)$service, (String)"$service");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return TaskPoolKt.recover(TaskPoolKt.task($service, (Function0)new Function0<KtFile>(this$0, path){
            final /* synthetic */ KtTreeCompiler this$0;
            final /* synthetic */ Path $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(0);
            }

            @NotNull
            public final KtFile invoke() {
                KtCompiler ktCompiler = KtTreeCompiler.access$getCompiler$p(this.this$0);
                Path path = KtTreeCompiler.access$getBasePath$p(this.this$0);
                Path path2 = this.$path;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                return ktCompiler.compile(path, path2);
            }
        }), (Function1)new Function1<Throwable, KtFile>(this$0, path){
            final /* synthetic */ KtTreeCompiler this$0;
            final /* synthetic */ Path $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(1);
            }

            @Nullable
            public final KtFile invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KtTreeCompiler.access$getSettings$p(this.this$0).error("Could not compile '" + this.$path + "'.", it);
                return null;
            }
        });
    }

    private static final KtFile compileProject$lambda-4(KtTreeCompiler this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        KtCompiler ktCompiler = this$0.compiler;
        Path path = this$0.basePath;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return ktCompiler.compile(path, it);
    }

    public static final /* synthetic */ KtCompiler access$getCompiler$p(KtTreeCompiler $this) {
        return $this.compiler;
    }

    public static final /* synthetic */ Path access$getBasePath$p(KtTreeCompiler $this) {
        return $this.basePath;
    }

    public static final /* synthetic */ ProcessingSettings access$getSettings$p(KtTreeCompiler $this) {
        return $this.settings;
    }

    static {
        Object[] objectArray = new String[]{"kt", "kts"};
        KT_ENDINGS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler$Companion;", "", "()V", "KT_ENDINGS", "", "", "getKT_ENDINGS", "()Ljava/util/Set;", "detekt-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getKT_ENDINGS() {
            return KT_ENDINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

