/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.github.detekt.tooling.api.InvalidConfig;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigValidator;
import io.gitlab.arturbosch.detekt.api.Extension;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.config.ConfigValidatorsKt;
import io.gitlab.arturbosch.detekt.core.config.DefaultPropertiesConfigValidator;
import io.gitlab.arturbosch.detekt.core.extensions.LoadingKt;
import io.gitlab.arturbosch.detekt.core.reporting.ColorizerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0000\u00a8\u0006\t"}, d2={"checkConfiguration", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "baseline", "Lio/gitlab/arturbosch/detekt/api/Config;", "renderMessage", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "detekt-core"})
public final class ConfigValidatorsKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkConfiguration(@NotNull ProcessingSettings settings2, @NotNull Config baseline) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        Config props = settings2.getConfig().subConfig("config");
        boolean shouldValidate = (Boolean)props.valueOrDefault("validation", (Object)true);
        if (shouldValidate) {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            void $this$forEach$iv;
            Iterator $this$mapTo$iv$iv;
            Iterable list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            void $this$onEach$iv$iv;
            Iterable $this$sortedBy$iv$iv;
            void $this$filterTo$iv$iv$iv;
            Iterable $this$filter$iv$iv;
            Extension it$iv;
            void $this$filterNotTo$iv$iv$iv;
            Iterable $this$filterNot$iv$iv;
            boolean $i$f$loadExtensions = false;
            Iterable<Object> iterable = ServiceLoader.load(ConfigValidator.class, settings2.getPluginLoader());
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"load(T::class.java, settings.pluginLoader)");
            iterable = iterable;
            boolean $i$f$filterNot = false;
            void var9_13 = $this$filterNot$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv$iv : $this$filterNotTo$iv$iv$iv) {
                it$iv = (Extension)element$iv$iv$iv;
                boolean bl = false;
                if (settings2.getSpec().getExtensionsSpec().getDisabledExtensions().contains(it$iv.getId())) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $this$filterNot$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$filter = false;
            $this$filterNotTo$iv$iv$iv = $this$filter$iv$iv;
            destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                Extension it = (Extension)element$iv$iv$iv;
                if (!true) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $this$filter$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv$iv = CollectionsKt.asReversed((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Extension it = (Extension)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (Extension)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            }));
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2d16$iv$iv = $this$filterTo$iv$iv$iv = $this$onEach$iv$iv;
            boolean $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22 = false;
            for (Object element$iv$iv : $this$onEach_u24lambda_u2d16$iv$iv) {
                it$iv = (Extension)element$iv$iv;
                boolean bl = false;
                it$iv.init(settings2.getConfig());
                it$iv.init((SetupContext)settings2);
            }
            $this$onEach$iv$iv = $this$filterTo$iv$iv$iv;
            Iterable it$iv2 = (List)$this$onEach$iv$iv;
            boolean bl = false;
            settings2.debug((Function0<String>)((Function0)new Function0<String>(it$iv2){
                final /* synthetic */ List<T> $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Loaded extensions: " + LoadingKt.getLIST_ITEM_SPACING() + CollectionsKt.joinToString$default((Iterable)this.$it, (CharSequence)LoadingKt.getLIST_ITEM_SPACING(), null, null, (int)0, null, null, (int)62, null);
                }
            }));
            List validators = CollectionsKt.plus((Collection)((List)$this$onEach$iv$iv), (Object)new DefaultPropertiesConfigValidator(settings2, baseline));
            Iterable $this$flatMap$iv = validators;
            boolean $i$f$flatMap = false;
            it$iv2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ConfigValidator it = (ConfigValidator)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = it.validate(settings2.getConfig());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List notifications = (List)destination$iv$iv;
            Iterable $this$map$iv = notifications;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22 = $this$mapTo$iv$iv.iterator();
            while ($i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22.hasNext()) {
                void p0;
                Object item$iv$iv = $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22.next();
                list$iv$iv = (Notification)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(p0.getMessage());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                String p0 = (String)element$iv2;
                boolean bl4 = false;
                settings2.info(p0);
            }
            Iterable $this$filter$iv = notifications;
            $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Notification p0 = (Notification)element$iv$iv;
                boolean bl5 = false;
                if (!p0.isError()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List errors = (List)destination$iv$iv2;
            if (!((Collection)errors).isEmpty()) {
                String problems2 = CollectionsKt.joinToString$default((Iterable)notifications, (CharSequence)JunkKt.getNL(), null, null, (int)0, null, (Function1)checkConfiguration.problems.1.INSTANCE, (int)30, null);
                String propsString = errors.size() == 1 ? "property" : "properties";
                String title = ColorizerKt.red("Run failed with " + errors.size() + " invalid config " + propsString + '.');
                throw new InvalidConfig(title + JunkKt.getNL() + problems2);
            }
        }
    }

    @NotNull
    public static final String renderMessage(@NotNull Notification $this$renderMessage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$renderMessage, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$renderMessage.getLevel().ordinal()]) {
            case 1: {
                string = ColorizerKt.red($this$renderMessage.getMessage());
                break;
            }
            case 2: {
                string = ColorizerKt.yellow($this$renderMessage.getMessage());
                break;
            }
            case 3: {
                string = $this$renderMessage.getMessage();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Notification.Level.values().length];
            nArray[Notification.Level.Error.ordinal()] = 1;
            nArray[Notification.Level.Warning.ordinal()] = 2;
            nArray[Notification.Level.Info.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

