/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.baseline;

import io.github.detekt.tooling.api.Baseline;
import io.github.detekt.tooling.api.BaselineProvider;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.core.baseline.BaselineHandler;
import io.gitlab.arturbosch.detekt.core.baseline.DefaultBaseline;
import io.gitlab.arturbosch.detekt.core.baseline.DefaultBaselineKt;
import io.gitlab.arturbosch.detekt.core.baseline.XmlExtensionsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\n0\u0011j\u0002`\u00122\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\n0\u0011j\u0002`\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u0018*\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/BaselineFormat;", "Lio/github/detekt/tooling/api/BaselineProvider;", "()V", "positions", "Lkotlin/Pair;", "", "Ljavax/xml/stream/XMLStreamException;", "getPositions", "(Ljavax/xml/stream/XMLStreamException;)Lkotlin/Pair;", "id", "", "Lio/github/detekt/tooling/api/FindingId;", "finding", "Lio/gitlab/arturbosch/detekt/api/Finding;", "of", "Lio/gitlab/arturbosch/detekt/core/baseline/DefaultBaseline;", "manuallySuppressedIssues", "", "Lio/github/detekt/tooling/api/FindingsIdList;", "currentIssues", "read", "sourcePath", "Ljava/nio/file/Path;", "write", "", "targetPath", "baseline", "Lio/github/detekt/tooling/api/Baseline;", "save", "Ljavax/xml/stream/XMLStreamWriter;", "InvalidState", "detekt-core"})
public final class BaselineFormat
implements BaselineProvider {
    private final Pair<Integer, Integer> getPositions(XMLStreamException $this$positions) {
        return TuplesKt.to((Object)$this$positions.getLocation().getLineNumber(), (Object)$this$positions.getLocation().getColumnNumber());
    }

    @NotNull
    public String id(@NotNull Finding finding) {
        Intrinsics.checkNotNullParameter((Object)finding, (String)"finding");
        return DefaultBaselineKt.getBaselineId(finding);
    }

    @NotNull
    public DefaultBaseline of(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, (String)"manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, (String)"currentIssues");
        return new DefaultBaseline(manuallySuppressedIssues, currentIssues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DefaultBaseline read(@NotNull Path sourcePath) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        try {
            Closeable closeable = Files.newInputStream(sourcePath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                SAXParserFactory sAXParserFactory;
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                SAXParserFactory $this$read_u24lambda_u2d1_u24lambda_u2d0 = sAXParserFactory = SAXParserFactory.newInstance();
                boolean bl2 = false;
                $this$read_u24lambda_u2d1_u24lambda_u2d0.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                SAXParser reader = sAXParserFactory.newSAXParser();
                BaselineHandler handler = new BaselineHandler();
                reader.parse(it, (DefaultHandler)handler);
                DefaultBaseline defaultBaseline = handler.createBaseline$detekt_core();
                return defaultBaseline;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (SAXParseException error) {
            Pair pair = TuplesKt.to((Object)error.getLineNumber(), (Object)error.getColumnNumber());
            int line = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw new InvalidState("Error on position " + line + ':' + column + " while reading the baseline xml file!", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull Path targetPath, @NotNull Baseline baseline) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        try {
            BufferedWriter bufferedWriter = Files.newBufferedWriter(targetPath, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(targetPath)");
            Closeable closeable = XmlExtensionsKt.addFinalNewLine(bufferedWriter);
            Throwable throwable = null;
            try {
                Writer it = (Writer)closeable;
                boolean bl = false;
                this.save(XmlExtensionsKt.prettyPrinter(XmlExtensionsKt.streamXml(it)), baseline);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XMLStreamException error) {
            Pair<Integer, Integer> pair = this.getPositions(error);
            int line = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw new InvalidState("Error on position " + line + ':' + column + " while writing the baseline xml file!", error);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void save(XMLStreamWriter $this$save, Baseline baseline) {
        String it;
        void $this$tag$iv;
        void var23_23;
        void $this$tag$iv2;
        void var15_15;
        XMLStreamWriter xMLStreamWriter;
        XMLStreamWriter $this$document_u24default$iv = $this$save;
        Object version$iv = null;
        Object encoding$iv = null;
        boolean $i$f$document = false;
        XMLStreamWriter $this$document_u24lambda_u2d0$iv = xMLStreamWriter = $this$document_u24default$iv;
        boolean bl = false;
        $this$document_u24lambda_u2d0$iv.writeStartDocument();
        XMLStreamWriter $this$save_u24lambda_u2d8 = $this$document_u24lambda_u2d0$iv;
        boolean bl2 = false;
        XMLStreamWriter xMLStreamWriter2 = $this$save_u24lambda_u2d8;
        String name$iv = "SmellBaseline";
        boolean $i$f$tag = false;
        void $this$tag_u24lambda_u2d1$iv = var15_15 = $this$tag$iv2;
        boolean bl3 = false;
        $this$tag_u24lambda_u2d1$iv.writeStartElement(name$iv);
        void $this$save_u24lambda_u2d8_u24lambda_u2d7 = $this$tag_u24lambda_u2d1$iv;
        boolean bl4 = false;
        void var20_20 = $this$save_u24lambda_u2d8_u24lambda_u2d7;
        String name$iv2 = "ManuallySuppressedIssues";
        boolean $i$f$tag2 = false;
        void $this$tag_u24lambda_u2d1$iv2 = var23_23 = $this$tag$iv;
        $i$a$-apply-XmlExtensionsKt$tag$1$iv = false;
        $this$tag_u24lambda_u2d1$iv2.writeStartElement(name$iv2);
        void $this$save_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d4 = $this$tag_u24lambda_u2d1$iv2;
        boolean bl5 = false;
        Iterable $this$forEach$iv = baseline.getManuallySuppressedIssues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl6 = false;
            XmlExtensionsKt.tag((XMLStreamWriter)$this$save_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d4, "ID", it);
        }
        $this$tag_u24lambda_u2d1$iv2.writeEndElement();
        $this$tag$iv = $this$save_u24lambda_u2d8_u24lambda_u2d7;
        name$iv2 = "CurrentIssues";
        $i$f$tag2 = false;
        $this$tag_u24lambda_u2d1$iv2 = var23_23 = $this$tag$iv;
        $i$a$-apply-XmlExtensionsKt$tag$1$iv = false;
        $this$tag_u24lambda_u2d1$iv2.writeStartElement(name$iv2);
        void $this$save_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6 = $this$tag_u24lambda_u2d1$iv2;
        boolean bl7 = false;
        $this$forEach$iv = baseline.getCurrentIssues();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl8 = false;
            XmlExtensionsKt.tag((XMLStreamWriter)$this$save_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6, "ID", it);
        }
        $this$tag_u24lambda_u2d1$iv2.writeEndElement();
        $this$tag_u24lambda_u2d1$iv.writeEndElement();
        $this$document_u24lambda_u2d0$iv.writeEndDocument();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/BaselineFormat$InvalidState;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "msg", "", "error", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "detekt-core"})
    public static final class InvalidState
    extends IllegalStateException {
        public InvalidState(@NotNull String msg, @NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(msg, error);
        }
    }
}

