/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.tooling;

import io.github.detekt.tooling.api.DefaultConfigurationProvider;
import io.github.detekt.tooling.api.spec.ExtensionsSpec;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.core.tooling.DefaultConfigProviderKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/core/tooling/DefaultConfigProvider;", "Lio/github/detekt/tooling/api/DefaultConfigurationProvider;", "()V", "extensionsSpec", "Lio/github/detekt/tooling/api/spec/ExtensionsSpec;", "copy", "", "targetLocation", "Ljava/nio/file/Path;", "get", "Lio/gitlab/arturbosch/detekt/api/Config;", "init", "detekt-core"})
public final class DefaultConfigProvider
implements DefaultConfigurationProvider {
    private ExtensionsSpec extensionsSpec;

    public void init(@NotNull ExtensionsSpec extensionsSpec) {
        Intrinsics.checkNotNullParameter((Object)extensionsSpec, (String)"extensionsSpec");
        this.extensionsSpec = extensionsSpec;
    }

    @NotNull
    public Config get() {
        ExtensionsSpec extensionsSpec = this.extensionsSpec;
        if (extensionsSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extensionsSpec");
            extensionsSpec = null;
        }
        return DefaultConfigProviderKt.access$getDefaultConfiguration(extensionsSpec);
    }

    public void copy(@NotNull Path targetLocation) {
        Intrinsics.checkNotNullParameter((Object)targetLocation, (String)"targetLocation");
        ExtensionsSpec extensionsSpec = this.extensionsSpec;
        if (extensionsSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extensionsSpec");
            extensionsSpec = null;
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(DefaultConfigProviderKt.access$configInputStream(extensionsSpec), targetLocation, copyOptionArray);
    }
}

