/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.baseline;

import io.github.detekt.tooling.api.Baseline;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.baseline.BaselineFormat;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B)\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0003J\u0013\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0003J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0004j\u0002`\u0010H\u0016J1\u0010\u0011\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001R\u001e\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/DefaultBaseline;", "Lio/github/detekt/tooling/api/Baseline;", "manuallySuppressedIssues", "", "", "Lio/github/detekt/tooling/api/FindingsIdList;", "currentIssues", "(Ljava/util/Set;Ljava/util/Set;)V", "getCurrentIssues", "()Ljava/util/Set;", "getManuallySuppressedIssues", "component1", "component2", "contains", "", "id", "Lio/github/detekt/tooling/api/FindingId;", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "detekt-core"})
public final class DefaultBaseline
implements Baseline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> manuallySuppressedIssues;
    @NotNull
    private final Set<String> currentIssues;

    public DefaultBaseline(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, (String)"manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, (String)"currentIssues");
        this.manuallySuppressedIssues = manuallySuppressedIssues;
        this.currentIssues = currentIssues;
    }

    @NotNull
    public Set<String> getManuallySuppressedIssues() {
        return this.manuallySuppressedIssues;
    }

    @NotNull
    public Set<String> getCurrentIssues() {
        return this.currentIssues;
    }

    public boolean contains(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getCurrentIssues().contains(id) || this.getManuallySuppressedIssues().contains(id);
    }

    @NotNull
    public final Set<String> component1() {
        return this.getManuallySuppressedIssues();
    }

    @NotNull
    public final Set<String> component2() {
        return this.getCurrentIssues();
    }

    @NotNull
    public final DefaultBaseline copy(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, (String)"manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, (String)"currentIssues");
        return new DefaultBaseline(manuallySuppressedIssues, currentIssues);
    }

    public static /* synthetic */ DefaultBaseline copy$default(DefaultBaseline defaultBaseline, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            set = defaultBaseline.getManuallySuppressedIssues();
        }
        if ((n & 2) != 0) {
            set2 = defaultBaseline.getCurrentIssues();
        }
        return defaultBaseline.copy(set, set2);
    }

    @NotNull
    public String toString() {
        return "DefaultBaseline(manuallySuppressedIssues=" + this.getManuallySuppressedIssues() + ", currentIssues=" + this.getCurrentIssues() + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.getManuallySuppressedIssues()).hashCode();
        result2 = result2 * 31 + ((Object)this.getCurrentIssues()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultBaseline)) {
            return false;
        }
        DefaultBaseline defaultBaseline = (DefaultBaseline)other;
        if (!Intrinsics.areEqual(this.getManuallySuppressedIssues(), defaultBaseline.getManuallySuppressedIssues())) {
            return false;
        }
        return Intrinsics.areEqual(this.getCurrentIssues(), defaultBaseline.getCurrentIssues());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/DefaultBaseline$Companion;", "", "()V", "load", "Lio/github/detekt/tooling/api/Baseline;", "baselineFile", "Ljava/nio/file/Path;", "detekt-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Baseline load(@NotNull Path baselineFile) {
            Intrinsics.checkNotNullParameter((Object)baselineFile, (String)"baselineFile");
            if (!JunkKt.exists(baselineFile)) {
                boolean $i$a$-require-DefaultBaseline$Companion$load$32 = false;
                String $i$a$-require-DefaultBaseline$Companion$load$32 = "Baseline file does not exist.";
                throw new IllegalArgumentException($i$a$-require-DefaultBaseline$Companion$load$32.toString());
            }
            if (!JunkKt.isFile(baselineFile)) {
                boolean bl = false;
                String string = "Baseline file is not a regular file.";
                throw new IllegalArgumentException(string.toString());
            }
            return new BaselineFormat().read(baselineFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

