/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.github.detekt.parser.KtCompiler;
import io.github.detekt.tooling.api.spec.ProjectSpec;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.core.KtTreeCompiler;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.TaskPool;
import io.gitlab.arturbosch.detekt.core.TaskPoolKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\nH\u0002J\f\u0010\u0015\u001a\u00020\u0014*\u00020\nH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler;", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "projectSpec", "Lio/github/detekt/tooling/api/spec/ProjectSpec;", "compiler", "Lio/github/detekt/parser/KtCompiler;", "(Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;Lio/github/detekt/tooling/api/spec/ProjectSpec;Lio/github/detekt/parser/KtCompiler;)V", "basePath", "Ljava/nio/file/Path;", "pathFilters", "Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "compile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "path", "compileProject", "project", "isIgnored", "", "isKotlinFile", "Companion", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nKtTreeCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtTreeCompiler.kt\nio/gitlab/arturbosch/detekt/core/KtTreeCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class KtTreeCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessingSettings settings;
    @NotNull
    private final KtCompiler compiler;
    @Nullable
    private final Path basePath;
    @Nullable
    private final PathFilters pathFilters;
    @NotNull
    private static final Set<String> KT_ENDINGS;

    public KtTreeCompiler(@NotNull ProcessingSettings settings2, @NotNull ProjectSpec projectSpec, @NotNull KtCompiler compiler) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)projectSpec, (String)"projectSpec");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        this.settings = settings2;
        this.compiler = compiler;
        this.basePath = projectSpec.getBasePath();
        this.pathFilters = PathFilters.Companion.of(CollectionsKt.toList((Iterable)projectSpec.getIncludes()), CollectionsKt.toList((Iterable)projectSpec.getExcludes()));
    }

    public /* synthetic */ KtTreeCompiler(ProcessingSettings processingSettings, ProjectSpec projectSpec, KtCompiler ktCompiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ktCompiler = new KtCompiler(processingSettings.getEnvironment());
        }
        this(processingSettings, projectSpec, ktCompiler);
    }

    @NotNull
    public final List<KtFile> compile(@NotNull Path path) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "Given path " + path + " does not exist!";
            throw new IllegalArgumentException(string.toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isRegularFile(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && this.isKotlinFile(path)) {
            list = CollectionsKt.listOf((Object)this.compiler.compile(this.basePath, path));
        } else {
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                list = this.compileProject(path);
            } else {
                this.settings.debug((Function0<String>)((Function0)new Function0<String>(path){
                    final /* synthetic */ Path $path;
                    {
                        this.$path = $path;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Ignoring a file detekt cannot handle: " + this.$path;
                    }
                }));
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    private final List<KtFile> compileProject(Path project) {
        Stream<Path> stream = Files.walk(project, new FileVisitOption[0]);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(project)");
        Sequence kotlinFiles2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), (Function1)compileProject.kotlinFiles.1.INSTANCE), (Function1)((Function1)new Function1<Path, Boolean>(this){
            final /* synthetic */ KtTreeCompiler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return KtTreeCompiler.access$isKotlinFile(this.this$0, it);
            }
        })), (Function1)((Function1)new Function1<Path, Boolean>(this){
            final /* synthetic */ KtTreeCompiler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return !KtTreeCompiler.access$isIgnored(this.this$0, it);
            }
        }));
        if (this.settings.getSpec().getExecutionSpec().getParallelParsing()) {
            TaskPool service = this.settings.getTaskPool();
            List tasks2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)kotlinFiles2, (Function1)((Function1)new Function1<Path, CompletableFuture<KtFile>>(service, this){
                final /* synthetic */ TaskPool $service;
                final /* synthetic */ KtTreeCompiler this$0;
                {
                    this.$service = $service;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CompletableFuture<KtFile> invoke(Path path) {
                    return TaskPoolKt.recover(TaskPoolKt.task(this.$service, (Function0)new Function0<KtFile>(this.this$0, path){
                        final /* synthetic */ KtTreeCompiler this$0;
                        final /* synthetic */ Path $path;
                        {
                            this.this$0 = $receiver;
                            this.$path = $path;
                            super(0);
                        }

                        @NotNull
                        public final KtFile invoke() {
                            KtCompiler ktCompiler = KtTreeCompiler.access$getCompiler$p(this.this$0);
                            Path path = KtTreeCompiler.access$getBasePath$p(this.this$0);
                            Path path2 = this.$path;
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                            return ktCompiler.compile(path, path2);
                        }
                    }), (Function1)new Function1<Throwable, KtFile>(this.this$0, path){
                        final /* synthetic */ KtTreeCompiler this$0;
                        final /* synthetic */ Path $path;
                        {
                            this.this$0 = $receiver;
                            this.$path = $path;
                            super(1);
                        }

                        @Nullable
                        public final KtFile invoke(@NotNull Throwable it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            KtTreeCompiler.access$getSettings$p(this.this$0).error("Could not compile '" + this.$path + "'.", it);
                            return null;
                        }
                    });
                }
            })));
            return CollectionsKt.filterNotNull((Iterable)TaskPoolKt.awaitAll(tasks2));
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)kotlinFiles2, (Function1)((Function1)new Function1<Path, KtFile>(this){
            final /* synthetic */ KtTreeCompiler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final KtFile invoke(Path it) {
                KtCompiler ktCompiler = KtTreeCompiler.access$getCompiler$p(this.this$0);
                Path path = KtTreeCompiler.access$getBasePath$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ktCompiler.compile(path, it);
            }
        })));
    }

    private final boolean isKotlinFile(Path $this$isKotlinFile) {
        return KT_ENDINGS.contains(PathsKt.getExtension((Path)$this$isKotlinFile));
    }

    private final boolean isIgnored(Path path) {
        Boolean ignored;
        PathFilters pathFilters = this.pathFilters;
        Boolean bl = ignored = pathFilters != null ? Boolean.valueOf(pathFilters.isIgnored(path)) : null;
        if (Intrinsics.areEqual((Object)ignored, (Object)true)) {
            this.settings.debug((Function0<String>)((Function0)new Function0<String>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Ignoring file '" + this.$path + '\'';
                }
            }));
        }
        Boolean bl2 = ignored;
        return bl2 != null ? bl2 : false;
    }

    public static final /* synthetic */ boolean access$isKotlinFile(KtTreeCompiler $this, Path $receiver) {
        return $this.isKotlinFile($receiver);
    }

    public static final /* synthetic */ boolean access$isIgnored(KtTreeCompiler $this, Path path) {
        return $this.isIgnored(path);
    }

    public static final /* synthetic */ KtCompiler access$getCompiler$p(KtTreeCompiler $this) {
        return $this.compiler;
    }

    public static final /* synthetic */ Path access$getBasePath$p(KtTreeCompiler $this) {
        return $this.basePath;
    }

    public static final /* synthetic */ ProcessingSettings access$getSettings$p(KtTreeCompiler $this) {
        return $this.settings;
    }

    static {
        Object[] objectArray = new String[]{"kt", "kts"};
        KT_ENDINGS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtTreeCompiler$Companion;", "", "()V", "KT_ENDINGS", "", "", "getKT_ENDINGS", "()Ljava/util/Set;", "detekt-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getKT_ENDINGS() {
            return KT_ENDINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

