/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.core.config.validation.ConfigValidationKt;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidatableConfiguration;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0001H\u00c2\u0003J\t\u0010\u0007\u001a\u00020\u0001H\u00c2\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J'\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u0004\u0018\u0001H\u001b\"\b\b\u0000\u0010\u001b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/core/config/AllRulesConfig;", "Lio/gitlab/arturbosch/detekt/api/Config;", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidatableConfiguration;", "originalConfig", "defaultConfig", "(Lio/gitlab/arturbosch/detekt/api/Config;Lio/gitlab/arturbosch/detekt/api/Config;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "subConfig", "key", "", "toString", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "baseline", "excludePatterns", "", "Lkotlin/text/Regex;", "valueOrDefault", "T", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "valueOrNull", "(Ljava/lang/String;)Ljava/lang/Object;", "detekt-core"})
public final class AllRulesConfig
implements Config,
ValidatableConfiguration {
    @NotNull
    private final Config originalConfig;
    @NotNull
    private final Config defaultConfig;

    public AllRulesConfig(@NotNull Config originalConfig, @NotNull Config defaultConfig) {
        Intrinsics.checkNotNullParameter((Object)originalConfig, (String)"originalConfig");
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        this.originalConfig = originalConfig;
        this.defaultConfig = defaultConfig;
    }

    @NotNull
    public AllRulesConfig subConfig(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new AllRulesConfig(this.originalConfig.subConfig(key), this.defaultConfig.subConfig(key));
    }

    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(t, (String)"default");
        if (Intrinsics.areEqual((Object)key, (Object)"active")) {
            Object object2 = this.originalConfig.valueOrDefault(key, (Object)true);
            object = object2;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type T of io.gitlab.arturbosch.detekt.core.config.AllRulesConfig.valueOrDefault");
        } else {
            object = this.originalConfig.valueOrDefault(key, this.defaultConfig.valueOrDefault(key, t));
        }
        return (T)object;
    }

    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (Intrinsics.areEqual((Object)key, (Object)"active")) {
            object = this.originalConfig.valueOrNull(key);
            if (object == null) {
                object = true;
            }
        } else {
            object = this.originalConfig.valueOrNull(key);
            if (object == null) {
                object = this.defaultConfig.valueOrNull(key);
            }
        }
        return (T)object;
    }

    @Override
    @NotNull
    public List<Notification> validate(@NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, (String)"excludePatterns");
        return ConfigValidationKt.validateConfig(this.originalConfig, baseline, excludePatterns);
    }

    @Nullable
    public String getParentPath() {
        return Config.DefaultImpls.getParentPath((Config)this);
    }

    private final Config component1() {
        return this.originalConfig;
    }

    private final Config component2() {
        return this.defaultConfig;
    }

    @NotNull
    public final AllRulesConfig copy(@NotNull Config originalConfig, @NotNull Config defaultConfig) {
        Intrinsics.checkNotNullParameter((Object)originalConfig, (String)"originalConfig");
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        return new AllRulesConfig(originalConfig, defaultConfig);
    }

    public static /* synthetic */ AllRulesConfig copy$default(AllRulesConfig allRulesConfig, Config config, Config config2, int n, Object object) {
        if ((n & 1) != 0) {
            config = allRulesConfig.originalConfig;
        }
        if ((n & 2) != 0) {
            config2 = allRulesConfig.defaultConfig;
        }
        return allRulesConfig.copy(config, config2);
    }

    @NotNull
    public String toString() {
        return "AllRulesConfig(originalConfig=" + this.originalConfig + ", defaultConfig=" + this.defaultConfig + ')';
    }

    public int hashCode() {
        int result2 = this.originalConfig.hashCode();
        result2 = result2 * 31 + this.defaultConfig.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AllRulesConfig)) {
            return false;
        }
        AllRulesConfig allRulesConfig = (AllRulesConfig)other;
        if (!Intrinsics.areEqual((Object)this.originalConfig, (Object)allRulesConfig.originalConfig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.defaultConfig, (Object)allRulesConfig.defaultConfig);
    }
}

