/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.baseline;

import io.github.detekt.tooling.api.Baseline;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.core.baseline.BaselineFilteredResult;
import io.gitlab.arturbosch.detekt.core.baseline.BaselineFormat;
import io.gitlab.arturbosch.detekt.core.baseline.DefaultBaseline;
import io.gitlab.arturbosch.detekt.core.baseline.DefaultBaselineKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/BaselineFacade;", "", "()V", "baselineExists", "", "baseline", "Ljava/nio/file/Path;", "createOrUpdate", "", "baselineFile", "findings", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "transformResult", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "result", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nBaselineFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaselineFacade.kt\nio/gitlab/arturbosch/detekt/core/baseline/BaselineFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1549#2:38\n1620#2,3:39\n*S KotlinDebug\n*F\n+ 1 BaselineFacade.kt\nio/gitlab/arturbosch/detekt/core/baseline/BaselineFacade\n*L\n21#1:38\n21#1:39,3\n*E\n"})
public final class BaselineFacade {
    @NotNull
    public final Detektion transformResult(@NotNull Path baselineFile, @NotNull Detektion result2) {
        Intrinsics.checkNotNullParameter((Object)baselineFile, (String)"baselineFile");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return this.baselineExists(baselineFile) ? (Detektion)new BaselineFilteredResult(result2, DefaultBaseline.Companion.load(baselineFile)) : result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void createOrUpdate(@NotNull Path baselineFile, @NotNull List<? extends Finding> findings) {
        BaselineFormat baselineFormat;
        Baseline baseline;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)baselineFile, (String)"baselineFile");
        Intrinsics.checkNotNullParameter(findings, (String)"findings");
        Iterable $this$map$iv = findings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Finding finding = (Finding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DefaultBaselineKt.getBaselineId((Finding)it));
        }
        SortedSet ids = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        Baseline oldBaseline = this.baselineExists(baselineFile) ? DefaultBaseline.Companion.load(baselineFile) : (Baseline)new DefaultBaseline(SetsKt.emptySet(), SetsKt.emptySet());
        if (!Intrinsics.areEqual((Object)oldBaseline, (Object)(baseline = (baselineFormat = new BaselineFormat()).of(oldBaseline.getManuallySuppressedIssues(), (Set)ids)))) {
            Path path;
            Path path2 = baselineFile.getParent();
            if (path2 != null) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(this, *attributes)");
            } else {
                path = null;
            }
            baselineFormat.write(baselineFile, baseline);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean baselineExists(Path baseline) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(baseline, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isRegularFile(baseline, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return false;
        return true;
    }
}

