/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config.validation;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigValidator;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidationSettings;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/AbstractYamlConfigValidator;", "Lio/gitlab/arturbosch/detekt/api/ConfigValidator;", "()V", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "configToValidate", "Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;", "settings", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidationSettings;", "detekt-core"})
public abstract class AbstractYamlConfigValidator
implements ConfigValidator {
    @NotNull
    public Collection<Notification> validate(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!(config instanceof YamlConfig)) {
            boolean bl = false;
            String yamlConfigClass = Reflection.getOrCreateKotlinClass(YamlConfig.class).getSimpleName();
            String actualClass = config.getClass().getSimpleName();
            String string = "Only supported config is the " + yamlConfigClass + ". Actual type is " + actualClass;
            throw new IllegalArgumentException(string.toString());
        }
        ValidationSettings settings2 = new ValidationSettings((Boolean)config.subConfig("config").valueOrDefault("checkExhaustiveness", (Object)false));
        return this.validate((YamlConfig)config, settings2);
    }

    @NotNull
    public abstract Collection<Notification> validate(@NotNull YamlConfig var1, @NotNull ValidationSettings var2);

    @NotNull
    public String getId() {
        return ConfigValidator.DefaultImpls.getId((ConfigValidator)this);
    }

    public int getPriority() {
        return ConfigValidator.DefaultImpls.getPriority((ConfigValidator)this);
    }

    public void init(@NotNull Config config) {
        ConfigValidator.DefaultImpls.init((ConfigValidator)this, (Config)config);
    }

    public void init(@NotNull SetupContext context) {
        ConfigValidator.DefaultImpls.init((ConfigValidator)this, (SetupContext)context);
    }
}

