/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.core.config.validation.ConfigValidationKt;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidatableConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J'\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u0004\u0018\u0001H\u0015\"\b\b\u0000\u0010\u0015*\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/CompositeConfig;", "Lio/gitlab/arturbosch/detekt/api/Config;", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidatableConfiguration;", "lookFirst", "lookSecond", "(Lio/gitlab/arturbosch/detekt/api/Config;Lio/gitlab/arturbosch/detekt/api/Config;)V", "parentPath", "", "getParentPath", "()Ljava/lang/String;", "subConfig", "key", "toString", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "baseline", "excludePatterns", "", "Lkotlin/text/Regex;", "valueOrDefault", "T", "", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "valueOrNull", "(Ljava/lang/String;)Ljava/lang/Object;", "detekt-core"})
public final class CompositeConfig
implements Config,
ValidatableConfiguration {
    @NotNull
    private final Config lookFirst;
    @NotNull
    private final Config lookSecond;

    public CompositeConfig(@NotNull Config lookFirst, @NotNull Config lookSecond) {
        Intrinsics.checkNotNullParameter((Object)lookFirst, (String)"lookFirst");
        Intrinsics.checkNotNullParameter((Object)lookSecond, (String)"lookSecond");
        this.lookFirst = lookFirst;
        this.lookSecond = lookSecond;
    }

    @Nullable
    public String getParentPath() {
        String string = this.lookFirst.getParentPath();
        if (string == null) {
            string = this.lookSecond.getParentPath();
        }
        return string;
    }

    @NotNull
    public Config subConfig(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new CompositeConfig(this.lookFirst.subConfig(key), this.lookSecond.subConfig(key));
    }

    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(t, (String)"default");
        if (this.lookFirst.valueOrNull(key) != null) {
            return (T)this.lookFirst.valueOrDefault(key, t);
        }
        return (T)this.lookSecond.valueOrDefault(key, t);
    }

    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.lookFirst.valueOrNull(key);
        if (object == null) {
            object = this.lookSecond.valueOrNull(key);
        }
        return (T)object;
    }

    @NotNull
    public String toString() {
        return "CompositeConfig(lookFirst=" + this.lookFirst + ", lookSecond=" + this.lookSecond + ')';
    }

    @Override
    @NotNull
    public List<Notification> validate(@NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, (String)"excludePatterns");
        return CollectionsKt.plus((Collection)ConfigValidationKt.validateConfig(this.lookFirst, baseline, excludePatterns), (Iterable)ConfigValidationKt.validateConfig(this.lookSecond, baseline, excludePatterns));
    }
}

