/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.core.config.BaseConfigKt;
import io.gitlab.arturbosch.detekt.core.config.validation.ConfigValidationKt;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidatableConfiguration;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB'\b\u0000\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J'\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;", "Lio/gitlab/arturbosch/detekt/api/Config;", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidatableConfiguration;", "properties", "", "", "", "parentPath", "(Ljava/util/Map;Ljava/lang/String;)V", "getParentPath", "()Ljava/lang/String;", "getProperties", "()Ljava/util/Map;", "subConfig", "key", "toString", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "baseline", "excludePatterns", "", "Lkotlin/text/Regex;", "valueOrDefault", "T", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "valueOrNull", "(Ljava/lang/String;)Ljava/lang/Object;", "Companion", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nYamlConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlConfig.kt\nio/gitlab/arturbosch/detekt/core/config/YamlConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class YamlConfig
implements Config,
ValidatableConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> properties;
    @Nullable
    private final String parentPath;
    private static final int YAML_DOC_LIMIT = 102400;
    private static final int ALIASES_LIMIT = 100;

    public YamlConfig(@NotNull Map<String, ? extends Object> properties, @Nullable String parentPath) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.properties = properties;
        this.parentPath = parentPath;
    }

    public /* synthetic */ YamlConfig(Map map, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(map, string);
    }

    @NotNull
    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    @Nullable
    public String getParentPath() {
        return this.parentPath;
    }

    @NotNull
    public Config subConfig(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.properties.get(key);
        if (object == null) {
            boolean bl = false;
            object = MapsKt.emptyMap();
        }
        Object subProperties = object;
        Intrinsics.checkNotNull((Object)subProperties, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        return new YamlConfig((Map)subProperties, this.getParentPath() == null ? key : this.getParentPath() + " > " + key);
    }

    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(t, (String)"default");
        Object result2 = this.properties.get(key);
        Object object = BaseConfigKt.valueOrDefaultInternal$default(this, key, result2, t, null, 8, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of io.gitlab.arturbosch.detekt.core.config.YamlConfig.valueOrDefault");
        return (T)object;
    }

    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.properties.get(key);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public String toString() {
        return "YamlConfig(properties=" + this.properties + ')';
    }

    @Override
    @NotNull
    public List<Notification> validate(@NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, (String)"excludePatterns");
        return ConfigValidationKt.validateConfig(this, baseline, excludePatterns);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/YamlConfig$Companion;", "", "()V", "ALIASES_LIMIT", "", "YAML_DOC_LIMIT", "createYamlLoad", "Lorg/snakeyaml/engine/v2/api/Load;", "load", "Lio/gitlab/arturbosch/detekt/api/Config;", "reader", "Ljava/io/Reader;", "path", "Ljava/nio/file/Path;", "detekt-core"})
    @SourceDebugExtension(value={"SMAP\nYamlConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlConfig.kt\nio/gitlab/arturbosch/detekt/core/config/YamlConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Config load(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-require-YamlConfig$Companion$load$42 = false;
                String $i$a$-require-YamlConfig$Companion$load$42 = "Configuration does not exist: " + path;
                throw new IllegalArgumentException($i$a$-require-YamlConfig$Companion$load$42.toString());
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                boolean $i$a$-require-YamlConfig$Companion$load$52 = false;
                String $i$a$-require-YamlConfig$Companion$load$52 = "Configuration must be a file: " + path;
                throw new IllegalArgumentException($i$a$-require-YamlConfig$Companion$load$52.toString());
            }
            if (!Files.isReadable(path)) {
                boolean bl = false;
                String string = "Configuration must be readable: " + path;
                throw new IllegalArgumentException(string.toString());
            }
            Path path2 = path;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Charset charset = Charsets.UTF_8;
            return this.load(new InputStreamReader(Files.newInputStream(path2, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Config load(@NotNull Reader reader) {
            YamlConfig yamlConfig;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Closeable closeable = reader;
            int n = 8192;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            Throwable throwable = null;
            try {
                Object $this$load_u24lambda_u245_u24lambda_u243;
                BufferedReader bufferedReader = (BufferedReader)closeable;
                boolean bl = false;
                Object object = Companion;
                try {
                    $this$load_u24lambda_u245_u24lambda_u243 = object;
                    boolean bl2 = false;
                    $this$load_u24lambda_u245_u24lambda_u243 = Result.constructor-impl((Object)((Map)((Companion)$this$load_u24lambda_u245_u24lambda_u243).createYamlLoad().loadFromReader((Reader)bufferedReader)));
                }
                catch (Throwable bl2) {
                    $this$load_u24lambda_u245_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object = $this$load_u24lambda_u245_u24lambda_u243;
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                if (throwable2 != null) {
                    Throwable it = throwable2;
                    boolean bl3 = false;
                    throw new Config.InvalidConfigurationError(it);
                }
                Map map = (Map)object;
                yamlConfig = map == null ? new YamlConfig(MapsKt.emptyMap(), null, 2, null) : new YamlConfig(map, null, 2, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return yamlConfig;
        }

        private final Load createYamlLoad() {
            return new Load(LoadSettings.builder().setAllowDuplicateKeys(false).setAllowRecursiveKeys(false).setCodePointLimit(102400).setMaxAliasesForCollections(100).build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

