/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config.validation;

import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import io.gitlab.arturbosch.detekt.core.config.validation.AbstractYamlConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidationSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJF\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010H\u0002JB\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator;", "Lio/gitlab/arturbosch/detekt/core/config/validation/AbstractYamlConfigValidator;", "baseline", "Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;", "deprecatedProperties", "", "", "excludePatterns", "Lkotlin/text/Regex;", "(Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;Ljava/util/Set;Ljava/util/Set;)V", "checkProp", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "propertyName", "propertyPath", "configToValidate", "", "", "testKeys", "parentPath", "validate", "", "settings", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidationSettings;", "Companion", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nInvalidPropertiesConfigValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidPropertiesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1747#2,3:91\n*S KotlinDebug\n*F\n+ 1 InvalidPropertiesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator\n*L\n28#1:91,3\n*E\n"})
public final class InvalidPropertiesConfigValidator
extends AbstractYamlConfigValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YamlConfig baseline;
    @NotNull
    private final Set<String> deprecatedProperties;
    @NotNull
    private final Set<Regex> excludePatterns;

    public InvalidPropertiesConfigValidator(@NotNull YamlConfig baseline, @NotNull Set<String> deprecatedProperties, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        Intrinsics.checkNotNullParameter(deprecatedProperties, (String)"deprecatedProperties");
        Intrinsics.checkNotNullParameter(excludePatterns, (String)"excludePatterns");
        this.baseline = baseline;
        this.deprecatedProperties = deprecatedProperties;
        this.excludePatterns = excludePatterns;
    }

    @Override
    @NotNull
    public Collection<Notification> validate(@NotNull YamlConfig configToValidate, @NotNull ValidationSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)configToValidate, (String)"configToValidate");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        return InvalidPropertiesConfigValidator.testKeys$default(this, configToValidate.getProperties(), this.baseline.getProperties(), null, 4, null);
    }

    private final List<Notification> testKeys(Map<String, ? extends Object> configToValidate, Map<String, ? extends Object> baseline, String parentPath) {
        List notifications = new ArrayList();
        for (String prop : configToValidate.keySet()) {
            boolean bl;
            String propertyPath;
            block4: {
                propertyPath = (parentPath == null ? "" : parentPath + '>') + prop;
                Iterable $this$any$iv = this.excludePatterns;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl2 = false;
                        if (!it.matches((CharSequence)propertyPath)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean isExcluded = bl;
            boolean isDeprecated = this.deprecatedProperties.contains(propertyPath);
            if (isExcluded || isDeprecated) continue;
            notifications.addAll((Collection)this.checkProp(prop, propertyPath, configToValidate, baseline));
        }
        return notifications;
    }

    static /* synthetic */ List testKeys$default(InvalidPropertiesConfigValidator invalidPropertiesConfigValidator, Map map, Map map2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return invalidPropertiesConfigValidator.testKeys(map, map2, string);
    }

    private final List<Notification> checkProp(String propertyName, String propertyPath, Map<String, ? extends Object> configToValidate, Map<String, ? extends Object> baseline) {
        if (!baseline.containsKey(propertyName)) {
            return CollectionsKt.listOf((Object)Companion.propertyDoesNotExists$detekt_core(propertyPath));
        }
        if (configToValidate.get(propertyName) instanceof String && baseline.get(propertyName) instanceof List) {
            return CollectionsKt.listOf((Object)Companion.propertyShouldBeAnArray$detekt_core(propertyPath));
        }
        Object object = configToValidate.get(propertyName);
        Map next = object instanceof Map ? (Map)object : null;
        Object object2 = baseline.get(propertyName);
        Map nextBase = object2 instanceof Map ? (Map)object2 : null;
        return next == null && nextBase != null ? CollectionsKt.listOf((Object)Companion.nestedConfigurationExpected$detekt_core(propertyPath)) : (baseline.containsKey(propertyName) && next != null && nextBase == null ? CollectionsKt.listOf((Object)Companion.unexpectedNestedConfiguration$detekt_core(propertyPath)) : (next != null && nextBase != null ? this.testKeys(next, nextBase, propertyPath) : CollectionsKt.emptyList()));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\tJ\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator$Companion;", "", "()V", "nestedConfigurationExpected", "Lio/gitlab/arturbosch/detekt/api/Notification;", "prop", "", "nestedConfigurationExpected$detekt_core", "propertyDoesNotExists", "propertyDoesNotExists$detekt_core", "propertyShouldBeAnArray", "propertyShouldBeAnArray$detekt_core", "unexpectedNestedConfiguration", "unexpectedNestedConfiguration$detekt_core", "detekt-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Notification propertyDoesNotExists$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
            return (Notification)new SimpleNotification("Property '" + prop + "' is misspelled or does not exist.", null, 2, null);
        }

        @NotNull
        public final Notification nestedConfigurationExpected$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
            return (Notification)new SimpleNotification("Nested config expected for '" + prop + "'.", null, 2, null);
        }

        @NotNull
        public final Notification unexpectedNestedConfiguration$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
            return (Notification)new SimpleNotification("Unexpected nested config for '" + prop + "'.", null, 2, null);
        }

        @NotNull
        public final Notification propertyShouldBeAnArray$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
            return (Notification)new SimpleNotification("Property '" + prop + "' should be a YAML array instead of a comma-separated String.", Notification.Level.Warning);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

