/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.rules;

import io.github.detekt.psi.KtFilesKt;
import io.github.detekt.tooling.api.spec.RulesSpec;
import io.gitlab.arturbosch.detekt.api.BaseRule;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.MultiRule;
import io.gitlab.arturbosch.detekt.api.RuleSet;
import io.gitlab.arturbosch.detekt.api.RuleSetProvider;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.rules.RuleSetLocator;
import io.gitlab.arturbosch.detekt.core.rules.RuleSetsKt;
import io.gitlab.arturbosch.detekt.core.rules.SingleRuleProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u0016\u0012\b\u0012\u00060\u0002j\u0002`\u0003\u0012\b\u0012\u00060\u0002j\u0002`\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"associateRuleIdsToRuleSetIds", "", "", "Lio/gitlab/arturbosch/detekt/api/RuleId;", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "ruleSets", "Lkotlin/sequences/Sequence;", "Lio/gitlab/arturbosch/detekt/api/RuleSet;", "createRuleProviders", "", "Lio/gitlab/arturbosch/detekt/api/RuleSetProvider;", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "isActive", "", "Lio/gitlab/arturbosch/detekt/api/Config;", "shouldAnalyzeFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitFile", "Lio/gitlab/arturbosch/detekt/api/Finding;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nRuleSets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleSets.kt\nio/gitlab/arturbosch/detekt/core/rules/RuleSetsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1360#2:65\n1446#2,5:66\n1#3:71\n*S KotlinDebug\n*F\n+ 1 RuleSets.kt\nio/gitlab/arturbosch/detekt/core/rules/RuleSetsKt\n*L\n30#1:65\n30#1:66,5\n*E\n"})
public final class RuleSetsKt {
    public static final boolean isActive(@NotNull Config $this$isActive) {
        Intrinsics.checkNotNullParameter((Object)$this$isActive, (String)"<this>");
        return (Boolean)$this$isActive.valueOrDefault("active", (Object)true);
    }

    public static final boolean shouldAnalyzeFile(@NotNull Config $this$shouldAnalyzeFile, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldAnalyzeFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PathFilters filters = PathFiltersKt.createPathFilters((Config)$this$shouldAnalyzeFile);
        return filters == null || !filters.isIgnored(KtFilesKt.absolutePath((PsiFile)((PsiFile)file)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Finding> visitFile(@NotNull RuleSet $this$visitFile, @NotNull KtFile file, @NotNull BindingContext bindingContext2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$visitFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        Iterable $this$flatMap$iv = $this$visitFile.getRules();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            BaseRule it = (BaseRule)element$iv$iv;
            boolean bl = false;
            BaseRule.visitFile$default((BaseRule)it, (KtFile)file, (BindingContext)bindingContext2, null, (int)4, null);
            Iterable list$iv$iv = it.getFindings();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List visitFile$default(RuleSet ruleSet, KtFile ktFile, BindingContext bindingContext2, int n, Object object) {
        if ((n & 2) != 0) {
            BindingContext bindingContext3 = BindingContext.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext3, (String)"EMPTY");
            bindingContext2 = bindingContext3;
        }
        return RuleSetsKt.visitFile(ruleSet, ktFile, bindingContext2);
    }

    @NotNull
    public static final Map<String, String> associateRuleIdsToRuleSetIds(@NotNull Sequence<RuleSet> ruleSets) {
        Intrinsics.checkNotNullParameter(ruleSets, (String)"ruleSets");
        return MapsKt.toMap((Sequence)SequencesKt.flatMap(ruleSets, (Function1)associateRuleIdsToRuleSetIds.1.INSTANCE));
    }

    @NotNull
    public static final List<RuleSetProvider> createRuleProviders(@NotNull ProcessingSettings $this$createRuleProviders) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$createRuleProviders, (String)"<this>");
        RulesSpec.RunPolicy runPolicy = $this$createRuleProviders.getSpec().getRulesSpec().getRunPolicy();
        if (Intrinsics.areEqual((Object)runPolicy, (Object)RulesSpec.RunPolicy.NoRestrictions.INSTANCE)) {
            list = new RuleSetLocator($this$createRuleProviders).load();
        } else if (runPolicy instanceof RulesSpec.RunPolicy.RestrictToSingleRule) {
            Object v1;
            String ruleId;
            String ruleSetId;
            block6: {
                Pair pair = ((RulesSpec.RunPolicy.RestrictToSingleRule)runPolicy).getId();
                ruleSetId = (String)pair.component1();
                ruleId = (String)pair.component2();
                Iterable iterable = new RuleSetLocator($this$createRuleProviders).load();
                for (Object t : iterable) {
                    RuleSetProvider it = (RuleSetProvider)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getRuleSetId(), (Object)ruleSetId)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            if (v1 == null) {
                boolean bl = false;
                String string = "There was no rule set with id '" + ruleSetId + "'.";
                throw new IllegalArgumentException(string.toString());
            }
            RuleSetProvider realProvider = v1;
            list = CollectionsKt.listOf((Object)new SingleRuleProvider(ruleId, realProvider));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private static final Sequence<String> associateRuleIdsToRuleSetIds$extractIds(BaseRule rule) {
        Sequence sequence;
        if (rule instanceof MultiRule) {
            sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((MultiRule)rule).getRules()), (Function1)((Function1)associateRuleIdsToRuleSetIds.extractIds.1.INSTANCE));
        } else {
            Object[] objectArray = new String[]{rule.getRuleId()};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        }
        return sequence;
    }

    public static final /* synthetic */ Sequence access$associateRuleIdsToRuleSetIds$extractIds(BaseRule rule) {
        return RuleSetsKt.associateRuleIdsToRuleSetIds$extractIds(rule);
    }
}

