/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.settings;

import io.github.detekt.tooling.api.spec.ExtensionsSpec;
import io.gitlab.arturbosch.detekt.core.settings.ClassloaderAware;
import java.io.Closeable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/core/settings/ExtensionFacade;", "Ljava/lang/AutoCloseable;", "Ljava/io/Closeable;", "Lio/gitlab/arturbosch/detekt/core/settings/ClassloaderAware;", "plugins", "Lio/github/detekt/tooling/api/spec/ExtensionsSpec$Plugins;", "(Lio/github/detekt/tooling/api/spec/ExtensionsSpec$Plugins;)V", "pluginLoader", "Ljava/lang/ClassLoader;", "getPluginLoader", "()Ljava/lang/ClassLoader;", "pluginLoader$delegate", "Lkotlin/Lazy;", "close", "", "closeLoaderIfNeeded", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nClassloaderAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassloaderAware.kt\nio/gitlab/arturbosch/detekt/core/settings/ExtensionFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1855#2:56\n1856#2:58\n1#3:57\n*S KotlinDebug\n*F\n+ 1 ClassloaderAware.kt\nio/gitlab/arturbosch/detekt/core/settings/ExtensionFacade\n*L\n22#1:56\n22#1:58\n*E\n"})
public final class ExtensionFacade
implements AutoCloseable,
Closeable,
ClassloaderAware {
    @Nullable
    private final ExtensionsSpec.Plugins plugins;
    @NotNull
    private final Lazy pluginLoader$delegate;

    public ExtensionFacade(@Nullable ExtensionsSpec.Plugins plugins) {
        this.plugins = plugins;
        Object object = this.plugins;
        if (object != null && (object = object.getPaths()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    boolean $i$a$-require-ExtensionFacade$1$32 = false;
                    String $i$a$-require-ExtensionFacade$1$32 = "Given plugin \u2018" + it + "\u2019 does not exist.";
                    throw new IllegalArgumentException($i$a$-require-ExtensionFacade$1$32.toString());
                }
                if (Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"jar")) continue;
                boolean bl2 = false;
                String string = "Given plugin \u2018" + it + "\u2019 is not a JAR.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.pluginLoader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ClassLoader>(this){
            final /* synthetic */ ExtensionFacade this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final ClassLoader invoke() {
                ClassLoader classLoader;
                ExtensionsSpec.Plugins plugins = ExtensionFacade.access$getPlugins$p(this.this$0);
                if ((plugins != null ? plugins.getLoader() : null) != null) {
                    classLoader = ExtensionFacade.access$getPlugins$p(this.this$0).getLoader();
                    if (classLoader == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                } else {
                    ExtensionsSpec.Plugins plugins2 = ExtensionFacade.access$getPlugins$p(this.this$0);
                    if ((plugins2 != null ? plugins2.getPaths() : null) != null) {
                        void $this$mapTo$iv$iv;
                        Collection collection = ExtensionFacade.access$getPlugins$p(this.this$0).getPaths();
                        if (collection == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        Iterable $this$map$iv = collection;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Path path = (Path)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl = false;
                            collection2.add(it.toUri().toURL());
                        }
                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        URL[] pluginUrls = thisCollection$iv.toArray(new URL[0]);
                        classLoader = new URLClassLoader(pluginUrls, this.this$0.getClass().getClassLoader());
                    } else {
                        classLoader = this.this$0.getClass().getClassLoader();
                    }
                }
                return classLoader;
            }
        }));
    }

    @Override
    @NotNull
    public ClassLoader getPluginLoader() {
        Lazy lazy = this.pluginLoader$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-pluginLoader>(...)");
        return (ClassLoader)object;
    }

    @Override
    public void close() {
        this.closeLoaderIfNeeded();
    }

    @Override
    public void closeLoaderIfNeeded() {
        ExtensionsSpec.Plugins plugins = this.plugins;
        if ((plugins != null ? plugins.getPaths() : null) != null) {
            ClassLoader classLoader = this.getPluginLoader();
            ExceptionUtilsKt.closeQuietly((Closeable)(classLoader instanceof URLClassLoader ? (URLClassLoader)classLoader : null));
        }
    }

    public static final /* synthetic */ ExtensionsSpec.Plugins access$getPlugins$p(ExtensionFacade $this) {
        return $this.plugins;
    }
}

