/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.util;

import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ'\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\tj\u0002`\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor;", "", "()V", "finished", "", "Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Entry;", "started", "", "Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "", "Lio/gitlab/arturbosch/detekt/core/util/StartMillis;", "allFinished", "", "finish", "", "phase", "measure", "R", "block", "Lkotlin/Function0;", "(Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "start", "Entry", "Phase", "detekt-core"})
public final class PerformanceMonitor {
    @NotNull
    private final List<Entry> finished = new LinkedList();
    @NotNull
    private final Map<Phase, Long> started = new EnumMap(Phase.class);

    @NotNull
    public final List<Entry> allFinished() {
        return this.finished;
    }

    public final void start(@NotNull Phase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        this.started.put(phase, System.currentTimeMillis());
    }

    public final void finish(@NotNull Phase phase) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Long l = this.started.get((Object)phase);
        if (l == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        long start = ((Number)l).longValue();
        long end = System.currentTimeMillis();
        this.finished.add(new Entry(phase, DurationKt.toDuration((long)(end - start), (DurationUnit)DurationUnit.MILLISECONDS), null));
    }

    public final <R> R measure(@NotNull Phase phase, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.start(phase);
        Object result2 = block.invoke();
        this.finish(phase);
        return (R)result2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0018\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\r\u001a\u00020\u0005H\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\bJ*\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001c\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Entry;", "", "phase", "Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "duration", "Lkotlin/time/Duration;", "(Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getDuration-UwyO8pc", "()J", "J", "getPhase", "()Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "component1", "component2", "component2-UwyO8pc", "copy", "copy-HG0u8IE", "(Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;J)Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Entry;", "equals", "", "other", "hashCode", "", "toString", "", "detekt-core"})
    public static final class Entry {
        @NotNull
        private final Phase phase;
        private final long duration;

        private Entry(Phase phase, long duration) {
            Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
            this.phase = phase;
            this.duration = duration;
        }

        @NotNull
        public final Phase getPhase() {
            return this.phase;
        }

        public final long getDuration-UwyO8pc() {
            return this.duration;
        }

        @NotNull
        public final Phase component1() {
            return this.phase;
        }

        public final long component2-UwyO8pc() {
            return this.duration;
        }

        @NotNull
        public final Entry copy-HG0u8IE(@NotNull Phase phase, long duration) {
            Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
            return new Entry(phase, duration, null);
        }

        public static /* synthetic */ Entry copy-HG0u8IE$default(Entry entry, Phase phase, long l, int n, Object object) {
            if ((n & 1) != 0) {
                phase = entry.phase;
            }
            if ((n & 2) != 0) {
                l = entry.duration;
            }
            return entry.copy-HG0u8IE(phase, l);
        }

        @NotNull
        public String toString() {
            return "Entry(phase=" + (Object)((Object)this.phase) + ", duration=" + Duration.toString-impl((long)this.duration) + ')';
        }

        public int hashCode() {
            int result2 = this.phase.hashCode();
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.duration);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (this.phase != entry.phase) {
                return false;
            }
            return Duration.equals-impl0((long)this.duration, (long)entry.duration);
        }

        public /* synthetic */ Entry(Phase phase, long duration, DefaultConstructorMarker $constructor_marker) {
            this(phase, duration);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/core/util/PerformanceMonitor$Phase;", "", "(Ljava/lang/String;I)V", "LoadConfig", "CreateSettings", "ValidateConfig", "Parsing", "Binding", "LoadingExtensions", "Analyzer", "Reporting", "detekt-core"})
    public static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase LoadConfig = new Phase();
        public static final /* enum */ Phase CreateSettings = new Phase();
        public static final /* enum */ Phase ValidateConfig = new Phase();
        public static final /* enum */ Phase Parsing = new Phase();
        public static final /* enum */ Phase Binding = new Phase();
        public static final /* enum */ Phase LoadingExtensions = new Phase();
        public static final /* enum */ Phase Analyzer = new Phase();
        public static final /* enum */ Phase Reporting = new Phase();
        private static final /* synthetic */ Phase[] $VALUES;

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value) {
            return Enum.valueOf(Phase.class, value);
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.LoadConfig, Phase.CreateSettings, Phase.ValidateConfig, Phase.Parsing, Phase.Binding, Phase.LoadingExtensions, Phase.Analyzer, Phase.Reporting};
        }
    }
}

