/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.core.Detektor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"readDetektVersionInManifest", "", "kotlin.jvm.PlatformType", "resource", "Ljava/net/URL;", "whichDetekt", "whichJava", "whichOS", "detekt-core"})
public final class DebugUtilsKt {
    @NotNull
    public static final String whichOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"os.name\")");
        return string;
    }

    @NotNull
    public static final String whichJava() {
        String string = System.getProperty("java.runtime.version");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"java.runtime.version\")");
        return string;
    }

    @NotNull
    public static final String whichDetekt() {
        Enumeration<URL> enumeration = Detektor.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"Detektor::class.java.cla\u2026s(\"META-INF/MANIFEST.MF\")");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            URL resource = (URL)iterator.next();
            try {
                URL uRL = resource;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"resource");
                String version = DebugUtilsKt.readDetektVersionInManifest(uRL);
                if (version == null) continue;
                return version;
            }
            catch (IOException iOException) {
            }
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String readDetektVersionInManifest(URL resource) {
        String string;
        Closeable closeable = resource.openStream();
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            string = new Manifest(it).getMainAttributes().getValue("DetektVersion");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }
}

