/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.api.internal.KotlinEnvironmentUtilsKt;
import io.gitlab.arturbosch.detekt.api.internal.PathMatchersKt;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.KtCompilerKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtCompiler;", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "psiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "getPsiFileFactory", "()Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "compile", "Lorg/jetbrains/kotlin/psi/KtFile;", "root", "Ljava/nio/file/Path;", "subPath", "createKtFile", "content", "", "path", "detekt-core"})
public class KtCompiler {
    @NotNull
    private final PsiFileFactory psiFileFactory;
    @NotNull
    private final KotlinCoreEnvironment environment;

    @NotNull
    protected final PsiFileFactory getPsiFileFactory() {
        return this.psiFileFactory;
    }

    @NotNull
    public final KtFile compile(@NotNull Path root, @NotNull Path subPath) {
        KtFile ktFile;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)subPath, (String)"subPath");
        boolean bl = JunkKt.isFile(subPath);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Given sub path should be a regular file!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path relativePath = (Intrinsics.areEqual((Object)root, (Object)subPath) ? subPath.getFileName() : root.getFileName().resolve(root.relativize(subPath))).normalize();
        Path absolutePath = subPath.toAbsolutePath().normalize();
        File file = subPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"subPath.toFile()");
        String content = FilesKt.readText$default((File)file, null, (int)1, null);
        String lineSeparator = KtCompilerKt.determineLineSeparator(content);
        String string = StringUtilRt.convertLineSeparators((String)content);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtilRt.convertLineSeparators(content)");
        String normalizedContent = string;
        Path path = absolutePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"absolutePath");
        KtFile ktFile2 = ktFile = this.createKtFile(normalizedContent, path);
        boolean bl5 = false;
        boolean bl6 = false;
        KtFile $this$apply = ktFile2;
        boolean bl7 = false;
        $this$apply.putUserData(JunkKt.getLINE_SEPARATOR(), (Object)lineSeparator);
        $this$apply.putUserData(PathMatchersKt.getRELATIVE_PATH(), (Object)((Object)relativePath).toString());
        $this$apply.putUserData(PathMatchersKt.getABSOLUTE_PATH(), (Object)((Object)absolutePath).toString());
        return ktFile2;
    }

    private final KtFile createKtFile(String content, Path path) {
        PsiFile psiFile = this.psiFileFactory.createFileFromText(((Object)path.getFileName()).toString(), (Language)KotlinLanguage.INSTANCE, (CharSequence)StringUtilRt.convertLineSeparators((String)content), true, true, false, (VirtualFile)new LightVirtualFile(((Object)path).toString()));
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            throw (Throwable)new IllegalStateException("kotlin file expected");
        }
        return ktFile;
    }

    @NotNull
    protected final KotlinCoreEnvironment getEnvironment() {
        return this.environment;
    }

    public KtCompiler(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull((Object)environment2, (String)"environment");
        this.environment = environment2;
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.environment.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFileFactory, (String)"PsiFileFactory.getInstance(environment.project)");
        this.psiFileFactory = psiFileFactory;
    }

    public /* synthetic */ KtCompiler(KotlinCoreEnvironment kotlinCoreEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kotlinCoreEnvironment = KotlinEnvironmentUtilsKt.createKotlinCoreEnvironment$default(null, null, (int)3, null);
        }
        this(kotlinCoreEnvironment);
    }

    public KtCompiler() {
        this(null, 1, null);
    }
}

