/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.PathMatchersKt;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.ModificationNotification;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tJ\f\u0010\u000b\u001a\u00020\f*\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/core/KtFileModifier;", "", "()V", "saveModifiedFiles", "", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "notification", "Lkotlin/Function1;", "Lio/gitlab/arturbosch/detekt/api/Notification;", "unnormalizeContent", "", "detekt-core"})
public final class KtFileModifier {
    /*
     * WARNING - void declaration
     */
    public final void saveModifiedFiles(@NotNull List<? extends KtFile> ktFiles, @NotNull Function1<? super Notification, Unit> notification) {
        void $this$mapTo$iv$iv;
        KtFile it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(ktFiles, (String)"ktFiles");
        Intrinsics.checkParameterIsNotNull(notification, (String)"notification");
        Iterable $this$filter$iv = ktFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getModificationStamp() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)Paths.get(PathMatchersKt.absolutePath((KtFile)it), new String[0]), (Object)this.unnormalizeContent(it));
            collection.add(pair);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] byArray;
            Pair it2 = (Pair)element$iv;
            boolean bl = false;
            Object object = it2.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first");
            notification.invoke((Object)new ModificationNotification((Path)object));
            String string = (String)it2.getSecond();
            Path path = (Path)it2.getFirst();
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
            Files.write(path, byArray, new OpenOption[0]);
        }
    }

    private final String unnormalizeContent(@NotNull KtFile $this$unnormalizeContent) {
        String lineSeparator = (String)$this$unnormalizeContent.getUserData(JunkKt.getLINE_SEPARATOR());
        boolean bl = lineSeparator != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "No line separator entry for ktFile " + JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)$this$unnormalizeContent).asString();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = StringUtilRt.convertLineSeparators((String)$this$unnormalizeContent.getText(), (String)lineSeparator);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtilRt.convertLine\u2026tors(text, lineSeparator)");
        return string;
    }
}

