/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.introspect;

import java.beans.PropertyDescriptor;

public class PropertyDTO {
    private String name;
    private String typeName;
    private boolean readable = true;
    private boolean writeable = true;
    private String description;
    private String displayName;
    private transient Class<?> typeClass;

    public PropertyDTO() {
    }

    public PropertyDTO(PropertyDescriptor propertyDescriptor) {
        this.name = propertyDescriptor.getName();
        this.displayName = propertyDescriptor.getDisplayName();
        this.typeClass = propertyDescriptor.getPropertyType();
        this.typeName = this.typeClass.getName();
        this.description = propertyDescriptor.getShortDescription();
        this.readable = propertyDescriptor.getReadMethod() != null;
        this.writeable = propertyDescriptor.getWriteMethod() != null;
    }

    public String toString() {
        return "Property(" + this.typeName + " " + this.name + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    Class<?> getTypeClass() {
        return this.typeClass;
    }

    void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }
}

