/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.interval;

import io.hypersistence.utils.hibernate.type.ImmutableType;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.spi.TypeBootstrapContext;

public class OracleIntervalDayToSecondType
extends ImmutableType<Duration> {
    public static final OracleIntervalDayToSecondType INSTANCE = new OracleIntervalDayToSecondType();
    private static final int SQL_COLUMN_TYPE = -104;
    private static final String INTERVAL_TOKENS = "%1$2d %2$2d:%3$2d:%4$2d.0";
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("(\\d+)\\s(\\d+):(\\d+):(\\d+)\\.\\d+");

    public OracleIntervalDayToSecondType() {
        super(Duration.class);
    }

    public OracleIntervalDayToSecondType(TypeBootstrapContext typeBootstrapContext) {
        super(Duration.class, new Configuration(typeBootstrapContext.getConfigurationSettings()));
    }

    @Override
    protected Duration get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        String intervalValue = rs.getString(position);
        if (intervalValue == null) {
            return null;
        }
        Matcher matcher = INTERVAL_PATTERN.matcher(intervalValue);
        if (matcher.matches()) {
            Integer days = Integer.parseInt(matcher.group(1));
            Integer hours = Integer.parseInt(matcher.group(2));
            Integer minutes = Integer.parseInt(matcher.group(3));
            Integer seconds = Integer.parseInt(matcher.group(4));
            return Duration.ofDays(days.intValue()).plus((long)hours.intValue(), ChronoUnit.HOURS).plus((long)minutes.intValue(), ChronoUnit.MINUTES).plus((long)Math.floor(seconds.intValue()), ChronoUnit.SECONDS);
        }
        throw new HibernateException((Throwable)new IllegalArgumentException("The parsed interval " + intervalValue + " does not match the expected pattern: " + INTERVAL_PATTERN));
    }

    @Override
    protected void set(PreparedStatement st, Duration value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, -104);
        } else {
            int days = (int)value.toDays();
            int hours = (int)(value.toHours() % 24L);
            int minutes = (int)(value.toMinutes() % 60L);
            int seconds = (int)(value.getSeconds() % 60L);
            st.setString(index, String.format(INTERVAL_TOKENS, days, hours, minutes, seconds));
        }
    }

    public int getSqlType() {
        return -104;
    }
}

