/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import io.joynr.accesscontrol.AceValidator;
import io.joynr.accesscontrol.TrustLevelComparator;
import javax.annotation.Nullable;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;

public class AccessControlAlgorithm {
    public Permission getConsumerPermission(@Nullable MasterAccessControlEntry master, @Nullable MasterAccessControlEntry mediator, @Nullable OwnerAccessControlEntry owner, TrustLevel trustLevel) {
        return this.getPermission(PermissionType.CONSUMER, master, mediator, owner, trustLevel);
    }

    public Permission getProviderPermission(@Nullable MasterAccessControlEntry master, @Nullable MasterAccessControlEntry mediator, @Nullable OwnerAccessControlEntry owner, TrustLevel trustLevel) {
        assert (false) : "Provider permission algorithm is not yet implemented!";
        return this.getPermission(PermissionType.PROVIDER, master, mediator, owner, trustLevel);
    }

    private Permission getPermission(PermissionType type, @Nullable MasterAccessControlEntry masterAce, @Nullable MasterAccessControlEntry mediatorAce, @Nullable OwnerAccessControlEntry ownerAce, TrustLevel trustLevel) {
        AceValidator aceValidator = new AceValidator(masterAce, mediatorAce, ownerAce);
        if (!aceValidator.isValid()) {
            return Permission.NO;
        }
        Permission permission = Permission.NO;
        if (ownerAce != null) {
            if (TrustLevelComparator.compare(trustLevel, ownerAce.getRequiredTrustLevel()) >= 0 && type == PermissionType.CONSUMER) {
                permission = ownerAce.getConsumerPermission();
            }
        } else if (mediatorAce != null) {
            if (TrustLevelComparator.compare(trustLevel, mediatorAce.getDefaultRequiredTrustLevel()) >= 0 && type == PermissionType.CONSUMER) {
                permission = mediatorAce.getDefaultConsumerPermission();
            }
        } else if (masterAce != null && TrustLevelComparator.compare(trustLevel, masterAce.getDefaultRequiredTrustLevel()) >= 0 && type == PermissionType.CONSUMER) {
            permission = masterAce.getDefaultConsumerPermission();
        }
        return permission;
    }

    private static enum PermissionType {
        PROVIDER,
        CONSUMER;

    }
}

