/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.joynr.accesscontrol.AccessController;
import io.joynr.accesscontrol.LocalDomainAccessController;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.arbitration.DiscoveryScope;
import io.joynr.capabilities.CapabilityListener;
import io.joynr.capabilities.LocalCapabilitiesDirectory;
import java.io.IOException;
import joynr.JoynrMessage;
import joynr.Request;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;
import joynr.types.DiscoveryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControllerImpl
implements AccessController {
    private static final Logger logger = LoggerFactory.getLogger(AccessControllerImpl.class);
    private final LocalCapabilitiesDirectory localCapabilitiesDirectory;
    private final LocalDomainAccessController localDomainAccessController;
    private final ObjectMapper objectMapper;

    @Inject
    AccessControllerImpl(LocalCapabilitiesDirectory localCapabilitiesDirectory, LocalDomainAccessController localDomainAccessController, ObjectMapper objectMapper) {
        this.localCapabilitiesDirectory = localCapabilitiesDirectory;
        this.localDomainAccessController = localDomainAccessController;
        this.objectMapper = objectMapper;
        this.defineAndRegisterCapabilityListener();
    }

    private void defineAndRegisterCapabilityListener() {
        this.localCapabilitiesDirectory.addCapabilityListener(new CapabilityListener(){

            public void capabilityRemoved(DiscoveryEntry removedCapability) {
                AccessControllerImpl.this.localDomainAccessController.unsubscribeFromAceChanges(removedCapability.getDomain(), removedCapability.getInterfaceName());
            }

            public void capabilityAdded(DiscoveryEntry addedCapability) {
            }
        });
    }

    @Override
    public boolean hasConsumerPermission(JoynrMessage message) {
        DiscoveryEntry discoveryEntry = this.getCapabilityEntry(message);
        if (discoveryEntry == null) {
            logger.error("Failed to get capability for participant id {} for acl check", (Object)message.getTo());
            return false;
        }
        String domain = discoveryEntry.getDomain();
        String interfaceName = discoveryEntry.getInterfaceName();
        String msgCreatorUid = message.getHeaderValue("creator");
        Permission permission = this.localDomainAccessController.getConsumerPermission(msgCreatorUid, domain, interfaceName, TrustLevel.HIGH);
        if (permission == null) {
            try {
                Request request = (Request)this.objectMapper.readValue(message.getPayload(), Request.class);
                String operation = request.getMethodName();
                permission = this.localDomainAccessController.getConsumerPermission(msgCreatorUid, domain, interfaceName, operation, TrustLevel.HIGH);
            }
            catch (IOException e) {
                logger.error("Cannot deserialize message", (Throwable)e);
                permission = Permission.NO;
            }
        }
        switch (permission) {
            case ASK: {
                assert (false) : "Permission.ASK user dialog not yet implemnted.";
                return false;
            }
            case YES: {
                return true;
            }
        }
        logger.warn("Message {} to domain {}, interface {} failed AccessControl check", new Object[]{message.getId(), discoveryEntry.getDomain(), discoveryEntry.getInterfaceName()});
        return false;
    }

    @Override
    public boolean hasProviderPermission(String userId, TrustLevel trustLevel, String domain, String interfaceName) {
        assert (false) : "Not yet implemented";
        return true;
    }

    private DiscoveryEntry getCapabilityEntry(JoynrMessage message) {
        long cacheMaxAge = Long.MAX_VALUE;
        DiscoveryQos discoveryQos = new DiscoveryQos(Long.MAX_VALUE, ArbitrationStrategy.NotSet, cacheMaxAge, DiscoveryScope.LOCAL_THEN_GLOBAL);
        String participantId = message.getTo();
        return this.localCapabilitiesDirectory.lookup(participantId, discoveryQos);
    }
}

