/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import io.joynr.accesscontrol.broadcastlistener.LdacDomainRoleEntryChangedBroadcastListener;
import io.joynr.accesscontrol.broadcastlistener.LdacMasterAccessControlEntryChangedBroadcastListener;
import io.joynr.accesscontrol.broadcastlistener.LdacMediatorAccessControlEntryChangedBroadcastListener;
import io.joynr.accesscontrol.broadcastlistener.LdacOwnerAccessControlEntryChangedBroadcastListener;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.arbitration.DiscoveryScope;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.Callback;
import io.joynr.proxy.Future;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.proxy.ProxyBuilderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import joynr.OnChangeSubscriptionQos;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.GlobalDomainAccessControllerBroadcastInterface;
import joynr.infrastructure.GlobalDomainAccessControllerProxy;

public class GlobalDomainAccessControllerClient {
    private static final long TTL_30_DAYS_IN_MS = 2592000000L;
    private String domain;
    private final ProxyBuilderFactory proxyBuilderFactory;

    public GlobalDomainAccessControllerClient(String domain, ProxyBuilderFactory proxyBuilderFactory) {
        this.domain = domain;
        this.proxyBuilderFactory = proxyBuilderFactory;
    }

    private GlobalDomainAccessControllerProxy getProxy(long ttl) {
        ProxyBuilder accessControlProxyBuilder = this.proxyBuilderFactory.get(this.domain, GlobalDomainAccessControllerProxy.class);
        DiscoveryQos discoveryQos = new DiscoveryQos();
        discoveryQos.setDiscoveryScope(DiscoveryScope.GLOBAL_ONLY);
        discoveryQos.setCacheMaxAgeMs(Long.MAX_VALUE);
        MessagingQos messagingQos = new MessagingQos(ttl);
        return (GlobalDomainAccessControllerProxy)accessControlProxyBuilder.setDiscoveryQos(discoveryQos).setMessagingQos(messagingQos).build();
    }

    public List<MasterAccessControlEntry> getMasterAccessControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getMasterAccessControlEntries(userId));
    }

    public Future<List<MasterAccessControlEntry>> getMasterAccessControlEntries(final Callback<List<MasterAccessControlEntry>> callback, String userId) {
        final Future future = new Future();
        this.getProxy(2592000000L).getMasterAccessControlEntries((Callback)new Callback<MasterAccessControlEntry[]>(){

            public void onFailure(JoynrRuntimeException error) {
                callback.onFailure(error);
                future.onFailure((JoynrException)error);
            }

            public void onSuccess(MasterAccessControlEntry[] result) {
                List<MasterAccessControlEntry> masterAccessContolEntry = result == null ? new ArrayList<MasterAccessControlEntry>() : Arrays.asList(result);
                callback.onSuccess(masterAccessContolEntry);
                future.onSuccess(masterAccessContolEntry);
            }
        }, userId);
        return future;
    }

    public boolean updateMasterAccessControlEntry(MasterAccessControlEntry updatedMasterAce) {
        return this.getProxy(2592000000L).updateMasterAccessControlEntry(updatedMasterAce);
    }

    public Future<Boolean> updateMasterAccessControlEntry(Callback<Boolean> callback, MasterAccessControlEntry updatedMasterAce) {
        return this.getProxy(2592000000L).updateMasterAccessControlEntry(callback, updatedMasterAce);
    }

    public boolean removeMasterAccessControlEntry(String userId, String domain, String interfaceName, String operation) {
        return this.getProxy(2592000000L).removeMasterAccessControlEntry(userId, domain, interfaceName, operation);
    }

    public List<MasterAccessControlEntry> getMediatorAccessControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getMediatorAccessControlEntries(userId));
    }

    public Future<Boolean> removeMasterAccessControlEntry(Callback<Boolean> callback, String userId, String domain, String interfaceName, String operation) {
        return this.getProxy(2592000000L).removeMasterAccessControlEntry(callback, userId, domain, interfaceName, operation);
    }

    public boolean updateMediatorAccessControlEntry(MasterAccessControlEntry updatedMediatorAce) {
        return this.getProxy(2592000000L).updateMediatorAccessControlEntry(updatedMediatorAce);
    }

    public Future<Boolean> updateMediatorAccessControlEntry(Callback<Boolean> callback, MasterAccessControlEntry updatedMediatorAce) {
        return this.getProxy(2592000000L).updateMediatorAccessControlEntry(callback, updatedMediatorAce);
    }

    public boolean removeMediatorAccessControlEntry(String userId, String domain, String interfaceName, String operation) {
        return this.getProxy(2592000000L).removeMediatorAccessControlEntry(userId, domain, interfaceName, operation);
    }

    public Future<Boolean> removeMediatorAccessControlEntry(Callback<Boolean> callback, String userId, String domain, String interfaceName, String operation) {
        return this.getProxy(2592000000L).removeMediatorAccessControlEntry(callback, userId, domain, interfaceName, operation);
    }

    public List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getOwnerAccessControlEntries(userId));
    }

    public boolean updateOwnerAccessControlEntry(OwnerAccessControlEntry updatedOwnerAce) {
        return this.getProxy(2592000000L).updateOwnerAccessControlEntry(updatedOwnerAce);
    }

    public Future<Boolean> updateOwnerAccessControlEntry(Callback<Boolean> callback, OwnerAccessControlEntry updatedOwnerAce) {
        return this.getProxy(2592000000L).updateOwnerAccessControlEntry(callback, updatedOwnerAce);
    }

    public boolean removeOwnerAccessControlEntry(String userId, String domain, String interfaceName, String operation) {
        return this.getProxy(2592000000L).removeOwnerAccessControlEntry(userId, domain, interfaceName, operation);
    }

    public Future<Boolean> removeOwnerAccessControlEntry(Callback<Boolean> callback, String userId, String domain, String interfaceName, String operation) {
        return this.getProxy(2592000000L).removeOwnerAccessControlEntry(callback, userId, domain, interfaceName, operation);
    }

    public List<MasterRegistrationControlEntry> getMasterRegistrationControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getMasterRegistrationControlEntries(userId));
    }

    public Future<List<MasterRegistrationControlEntry>> getMasterRegistrationControlEntries(final Callback<List<MasterRegistrationControlEntry>> callback, String userId) {
        final Future future = new Future();
        this.getProxy(2592000000L).getMasterRegistrationControlEntries((Callback)new Callback<MasterRegistrationControlEntry[]>(){

            public void onFailure(JoynrRuntimeException error) {
                callback.onFailure(error);
                future.onFailure((JoynrException)error);
            }

            public void onSuccess(MasterRegistrationControlEntry[] result) {
                List<MasterRegistrationControlEntry> masterRegistrationControlEntryList = result == null ? new ArrayList<MasterRegistrationControlEntry>() : Arrays.asList(result);
                callback.onSuccess(masterRegistrationControlEntryList);
                future.onSuccess(masterRegistrationControlEntryList);
            }
        }, userId);
        return future;
    }

    public List<MasterRegistrationControlEntry> getEditableMasterRegistrationControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getEditableMasterRegistrationControlEntries(userId));
    }

    public Future<List<MasterRegistrationControlEntry>> getEditableMasterRegistrationControlEntries(final Callback<List<MasterRegistrationControlEntry>> callback, String userId) {
        final Future future = new Future();
        this.getProxy(2592000000L).getEditableMasterRegistrationControlEntries((Callback)new Callback<MasterRegistrationControlEntry[]>(){

            public void onFailure(JoynrRuntimeException error) {
                callback.onFailure(error);
                future.onFailure((JoynrException)error);
            }

            public void onSuccess(MasterRegistrationControlEntry[] result) {
                List<MasterRegistrationControlEntry> masterRegistrationControlEntryList = result == null ? new ArrayList<MasterRegistrationControlEntry>() : Arrays.asList(result);
                callback.onSuccess(masterRegistrationControlEntryList);
                future.onSuccess(masterRegistrationControlEntryList);
            }
        }, userId);
        return future;
    }

    public List<MasterRegistrationControlEntry> getMediatorRegistrationControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getMediatorRegistrationControlEntries(userId));
    }

    public Future<List<MasterRegistrationControlEntry>> getMediatorRegistrationControlEntries(final Callback<List<MasterRegistrationControlEntry>> callback, String userId) {
        final Future future = new Future();
        this.getProxy(2592000000L).getMediatorRegistrationControlEntries((Callback)new Callback<MasterRegistrationControlEntry[]>(){

            public void onFailure(JoynrRuntimeException error) {
                callback.onFailure(error);
                future.onFailure((JoynrException)error);
            }

            public void onSuccess(MasterRegistrationControlEntry[] result) {
                List<MasterRegistrationControlEntry> masterRegistrationControlEntryList = result == null ? new ArrayList<MasterRegistrationControlEntry>() : Arrays.asList(result);
                callback.onSuccess(masterRegistrationControlEntryList);
                future.onSuccess(masterRegistrationControlEntryList);
            }
        }, userId);
        return future;
    }

    public List<MasterRegistrationControlEntry> getEditableMediatorRegistrationControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getEditableMediatorRegistrationControlEntries(userId));
    }

    public List<OwnerRegistrationControlEntry> getOwnerRegistrationControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getOwnerRegistrationControlEntries(userId));
    }

    public Future<List<OwnerRegistrationControlEntry>> getOwnerRegistrationControlEntries(final Callback<List<OwnerRegistrationControlEntry>> callback, String userId) {
        final Future future = new Future();
        this.getProxy(2592000000L).getOwnerRegistrationControlEntries((Callback)new Callback<OwnerRegistrationControlEntry[]>(){

            public void onFailure(JoynrRuntimeException error) {
                callback.onFailure(error);
                future.onFailure((JoynrException)error);
            }

            public void onSuccess(OwnerRegistrationControlEntry[] result) {
                List<OwnerRegistrationControlEntry> ownerRegistrationControlEntryList = result == null ? new ArrayList<OwnerRegistrationControlEntry>() : Arrays.asList(result);
                callback.onSuccess(ownerRegistrationControlEntryList);
                future.onSuccess(ownerRegistrationControlEntryList);
            }
        }, userId);
        return future;
    }

    public List<OwnerRegistrationControlEntry> getEditableOwnerRegistrationControlEntries(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getEditableOwnerRegistrationControlEntries(userId));
    }

    public Future<List<OwnerRegistrationControlEntry>> getEditableOwnerRegistrationControlEntries(final Callback<List<OwnerRegistrationControlEntry>> callback, String userId) {
        final Future future = new Future();
        this.getProxy(2592000000L).getEditableOwnerRegistrationControlEntries((Callback)new Callback<OwnerRegistrationControlEntry[]>(){

            public void onFailure(JoynrRuntimeException error) {
                callback.onFailure(error);
                future.onFailure((JoynrException)error);
            }

            public void onSuccess(OwnerRegistrationControlEntry[] result) {
                List<OwnerRegistrationControlEntry> ownerRegistrationControlEntryList = result == null ? new ArrayList<OwnerRegistrationControlEntry>() : Arrays.asList(result);
                callback.onSuccess(ownerRegistrationControlEntryList);
                future.onSuccess(ownerRegistrationControlEntryList);
            }
        }, userId);
        return future;
    }

    public void subscribeToDomainRoleEntryChangedBroadcast(LdacDomainRoleEntryChangedBroadcastListener ldacDomainRoleEntryChangedBroadcastListener, OnChangeSubscriptionQos broadcastSubscriptionQos, GlobalDomainAccessControllerBroadcastInterface.DomainRoleEntryChangedBroadcastFilterParameters domainRoleFilterParameters) {
        this.getProxy(2592000000L).subscribeToDomainRoleEntryChangedBroadcast((GlobalDomainAccessControllerBroadcastInterface.DomainRoleEntryChangedBroadcastListener)ldacDomainRoleEntryChangedBroadcastListener, broadcastSubscriptionQos, domainRoleFilterParameters);
    }

    public String subscribeToMasterAccessControlEntryChangedBroadcast(LdacMasterAccessControlEntryChangedBroadcastListener ldacMasterAccessControlEntryChangedBroadcastListener, OnChangeSubscriptionQos broadcastSubscriptionQos, GlobalDomainAccessControllerBroadcastInterface.MasterAccessControlEntryChangedBroadcastFilterParameters masterAcefilterParameters) {
        return this.getProxy(2592000000L).subscribeToMasterAccessControlEntryChangedBroadcast((GlobalDomainAccessControllerBroadcastInterface.MasterAccessControlEntryChangedBroadcastListener)ldacMasterAccessControlEntryChangedBroadcastListener, broadcastSubscriptionQos, masterAcefilterParameters);
    }

    public String subscribeToMediatorAccessControlEntryChangedBroadcast(LdacMediatorAccessControlEntryChangedBroadcastListener ldacMediatorAccessControlEntryChangedBroadcastListener, OnChangeSubscriptionQos broadcastSubscriptionQos, GlobalDomainAccessControllerBroadcastInterface.MediatorAccessControlEntryChangedBroadcastFilterParameters mediatorAceFilterParameters) {
        return this.getProxy(2592000000L).subscribeToMediatorAccessControlEntryChangedBroadcast((GlobalDomainAccessControllerBroadcastInterface.MediatorAccessControlEntryChangedBroadcastListener)ldacMediatorAccessControlEntryChangedBroadcastListener, broadcastSubscriptionQos, mediatorAceFilterParameters);
    }

    public String subscribeToOwnerAccessControlEntryChangedBroadcast(LdacOwnerAccessControlEntryChangedBroadcastListener ldacOwnerAccessControlEntryChangedBroadcastListener, OnChangeSubscriptionQos broadcastSubscriptionQos, GlobalDomainAccessControllerBroadcastInterface.OwnerAccessControlEntryChangedBroadcastFilterParameters ownerAceFilterParameters) {
        return this.getProxy(2592000000L).subscribeToOwnerAccessControlEntryChangedBroadcast((GlobalDomainAccessControllerBroadcastInterface.OwnerAccessControlEntryChangedBroadcastListener)ldacOwnerAccessControlEntryChangedBroadcastListener, broadcastSubscriptionQos, ownerAceFilterParameters);
    }

    public List<DomainRoleEntry> getDomainRoles(String userId) {
        return Arrays.asList(this.getProxy(2592000000L).getDomainRoles(userId));
    }

    public List<MasterAccessControlEntry> getMasterAccessControlEntries(String domain, String interfaceName) {
        return Arrays.asList(this.getProxy(2592000000L).getMasterAccessControlEntries(domain, interfaceName));
    }

    public List<MasterAccessControlEntry> getMediatorAccessControlEntries(String domain, String interfaceName) {
        return Arrays.asList(this.getProxy(2592000000L).getMediatorAccessControlEntries(domain, interfaceName));
    }

    public List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String domain, String interfaceName) {
        return Arrays.asList(this.getProxy(2592000000L).getOwnerAccessControlEntries(domain, interfaceName));
    }

    public void unsubscribeFromMasterAccessControlEntryChangedBroadcast(String subscriptionId) {
        this.getProxy(2592000000L).unsubscribeFromMasterAccessControlEntryChangedBroadcast(subscriptionId);
    }

    public void unsubscribeFromMediatorAccessControlEntryChangedBroadcast(String subscriptionId) {
        this.getProxy(2592000000L).unsubscribeFromMediatorAccessControlEntryChangedBroadcast(subscriptionId);
    }

    public void unsubscribeFromOwnerAccessControlEntryChangedBroadcast(String subscriptionId) {
        this.getProxy(2592000000L).unsubscribeFromOwnerAccessControlEntryChangedBroadcast(subscriptionId);
    }
}

