/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.accesscontrol.AccessControlAlgorithm;
import io.joynr.accesscontrol.DomainAccessControlStore;
import io.joynr.accesscontrol.GlobalDomainAccessControllerClient;
import io.joynr.accesscontrol.LocalDomainAccessController;
import io.joynr.accesscontrol.broadcastlistener.LdacDomainRoleEntryChangedBroadcastListener;
import io.joynr.accesscontrol.broadcastlistener.LdacMasterAccessControlEntryChangedBroadcastListener;
import io.joynr.accesscontrol.broadcastlistener.LdacMediatorAccessControlEntryChangedBroadcastListener;
import io.joynr.accesscontrol.broadcastlistener.LdacOwnerAccessControlEntryChangedBroadcastListener;
import io.joynr.accesscontrol.primarykey.UserDomainInterfaceOperationKey;
import io.joynr.proxy.Callback;
import io.joynr.proxy.Future;
import io.joynr.proxy.ProxyBuilderFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import joynr.OnChangeSubscriptionQos;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.Role;
import joynr.infrastructure.DacTypes.TrustLevel;
import joynr.infrastructure.GlobalDomainAccessControllerBroadcastInterface;
import joynr.types.GlobalDiscoveryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalDomainAccessControllerImpl
implements LocalDomainAccessController {
    private static final long QOS_MIN_INTERVAL_MS = 1000L;
    private static final long QOS_DURATION_MS = 315360000000L;
    private static final long QOS_PUBLICATION_TTL_MS = 5000L;
    private static final Logger LOG = LoggerFactory.getLogger(LocalDomainAccessControllerImpl.class);
    private final String discoveryDirectoriesDomain;
    private AccessControlAlgorithm accessControlAlgorithm = new AccessControlAlgorithm();
    private static final String WILDCARD = "*";
    private Map<UserDomainInterfaceOperationKey, AceSubscription> subscriptionsMap = new HashMap<UserDomainInterfaceOperationKey, AceSubscription>();
    private GlobalDomainAccessControllerClient globalDomainAccessControllerClient;
    private DomainAccessControlStore localDomainAccessStore;
    private String systemServicesDomain;

    @Inject
    public LocalDomainAccessControllerImpl(@Named(value="joynr.messaging.capabilitiesdirectory.discoveryentry") GlobalDiscoveryEntry capabilitiesDirectoryEntry, DomainAccessControlStore localDomainAccessStore, ProxyBuilderFactory proxyBuilderFactory, @Named(value="joynr.messaging.systemservicesdomain") String systemServicesDomain) {
        this.discoveryDirectoriesDomain = capabilitiesDirectoryEntry.getDomain();
        this.localDomainAccessStore = localDomainAccessStore;
        this.systemServicesDomain = systemServicesDomain;
        this.globalDomainAccessControllerClient = new GlobalDomainAccessControllerClient(this.discoveryDirectoriesDomain, proxyBuilderFactory);
    }

    @Override
    public boolean hasRole(String userId, String domain, Role role) {
        List<String> domains;
        boolean hasRole = false;
        DomainRoleEntry dre = this.localDomainAccessStore.getDomainRole(userId, role);
        if (dre != null && (domains = Arrays.asList(dre.getDomains())).contains(domain)) {
            hasRole = true;
        }
        if (!hasRole) {
            this.subscribeForDreChange(userId);
        }
        return hasRole;
    }

    @Override
    @CheckForNull
    public Permission getConsumerPermission(String userId, String domain, String interfaceName, TrustLevel trustLevel) {
        UserDomainInterfaceOperationKey subscriptionKey = new UserDomainInterfaceOperationKey(null, domain, interfaceName, null);
        LOG.debug("getConsumerPermission on domain {}, interface {}", (Object)domain, (Object)interfaceName);
        Permission specialPermission = this.handleSpecialCases(domain, interfaceName);
        if (specialPermission != null) {
            return specialPermission;
        }
        if (this.subscriptionsMap.get(subscriptionKey) == null) {
            this.initializeLocalDomainAccessStore(userId, domain, interfaceName);
            this.subscriptionsMap.put(subscriptionKey, this.subscribeForAceChange(domain, interfaceName));
        }
        List masterAces = this.localDomainAccessStore.getMasterAccessControlEntries(userId, domain, interfaceName);
        List mediatorAces = this.localDomainAccessStore.getMediatorAccessControlEntries(userId, domain, interfaceName);
        List ownerAces = this.localDomainAccessStore.getOwnerAccessControlEntries(userId, domain, interfaceName);
        if (masterAces != null && masterAces.size() > 1 || mediatorAces != null && mediatorAces.size() > 1 || ownerAces != null && ownerAces.size() > 1) {
            return null;
        }
        return this.getConsumerPermission(userId, domain, interfaceName, WILDCARD, trustLevel);
    }

    @CheckForNull
    private Permission handleSpecialCases(String domain, String interfaceName) {
        if ((domain.equals(this.discoveryDirectoriesDomain) || domain.equals(this.systemServicesDomain)) && (interfaceName.equals("infrastructure/GlobalCapabilitiesDirectory") || interfaceName.equals("infrastructure/GlobalDomainAccessController") || interfaceName.equals("system/Discovery") || interfaceName.equals("system/Routing"))) {
            return Permission.YES;
        }
        return null;
    }

    @Override
    public Permission getConsumerPermission(String userId, String domain, String interfaceName, String operation, TrustLevel trustLevel) {
        LOG.debug("getConsumerPermission on domain {}, interface {}", (Object)domain, (Object)interfaceName);
        MasterAccessControlEntry masterAce = this.localDomainAccessStore.getMasterAccessControlEntry(userId, domain, interfaceName, operation);
        MasterAccessControlEntry mediatorAce = this.localDomainAccessStore.getMediatorAccessControlEntry(userId, domain, interfaceName, operation);
        OwnerAccessControlEntry ownerAce = this.localDomainAccessStore.getOwnerAccessControlEntry(userId, domain, interfaceName, operation);
        return this.accessControlAlgorithm.getConsumerPermission(masterAce, mediatorAce, ownerAce, trustLevel);
    }

    @Override
    public List<MasterAccessControlEntry> getMasterAccessControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getMasterAccessControlEntries(uid);
    }

    @Override
    public Future<List<MasterAccessControlEntry>> getMasterAccessControlEntries(Callback<List<MasterAccessControlEntry>> callback, String uid) {
        return this.globalDomainAccessControllerClient.getMasterAccessControlEntries(callback, uid);
    }

    @Override
    public List<MasterAccessControlEntry> getEditableMasterAccessControlEntries(String uid) {
        throw new UnsupportedOperationException("Editing of access control entries is not implemented yet.");
    }

    @Override
    public Future<List<MasterAccessControlEntry>> getEditableMasterAccessControlEntries(Callback<List<MasterAccessControlEntry>> callback, String uid) {
        throw new UnsupportedOperationException("Editing of access control entries is not implemented yet.");
    }

    @Override
    public boolean updateMasterAccessControlEntry(MasterAccessControlEntry updatedMasterAce) {
        return this.globalDomainAccessControllerClient.updateMasterAccessControlEntry(updatedMasterAce);
    }

    @Override
    public Future<Boolean> updateMasterAccessControlEntry(Callback<Boolean> callback, MasterAccessControlEntry updatedMasterAce) {
        return this.globalDomainAccessControllerClient.updateMasterAccessControlEntry(callback, updatedMasterAce);
    }

    @Override
    public boolean removeMasterAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        return this.globalDomainAccessControllerClient.removeMasterAccessControlEntry(uid, domain, interfaceName, operation);
    }

    @Override
    public Future<Boolean> removeMasterAccessControlEntry(Callback<Boolean> callback, String uid, String domain, String interfaceName, String operation) {
        return this.globalDomainAccessControllerClient.removeMasterAccessControlEntry(callback, uid, domain, interfaceName, operation);
    }

    @Override
    public List<MasterAccessControlEntry> getMediatorAccessControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getMediatorAccessControlEntries(uid);
    }

    @Override
    public Future<List<MasterAccessControlEntry>> getMediatorAccessControlEntries(Callback<List<MasterAccessControlEntry>> callback, String uid) {
        return null;
    }

    @Override
    public List<MasterAccessControlEntry> getEditableMediatorAccessControlEntries(String uid) {
        return null;
    }

    @Override
    public Future<List<MasterAccessControlEntry>> getEditableMediatorAccessControlEntries(Callback<List<MasterAccessControlEntry>> callback, String uid) {
        return null;
    }

    @Override
    public boolean updateMediatorAccessControlEntry(MasterAccessControlEntry updatedMediatorAce) {
        return this.globalDomainAccessControllerClient.updateMediatorAccessControlEntry(updatedMediatorAce);
    }

    @Override
    public Future<Boolean> updateMediatorAccessControlEntry(Callback<Boolean> callback, MasterAccessControlEntry updatedMediatorAce) {
        return this.globalDomainAccessControllerClient.updateMediatorAccessControlEntry(callback, updatedMediatorAce);
    }

    @Override
    public boolean removeMediatorAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        return this.globalDomainAccessControllerClient.removeMediatorAccessControlEntry(uid, domain, interfaceName, operation);
    }

    @Override
    public Future<Boolean> removeMediatorAccessControlEntry(Callback<Boolean> callback, String uid, String domain, String interfaceName, String operation) {
        return this.globalDomainAccessControllerClient.removeMediatorAccessControlEntry(callback, uid, domain, interfaceName, operation);
    }

    @Override
    public List<OwnerAccessControlEntry> getOwnerAccessControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getOwnerAccessControlEntries(uid);
    }

    @Override
    public Future<List<OwnerAccessControlEntry>> getOwnerAccessControlEntries(Callback<List<OwnerAccessControlEntry>> callback, String uid) {
        throw new UnsupportedOperationException("Editing of access control entries is not implemented yet.");
    }

    @Override
    public List<OwnerAccessControlEntry> getEditableOwnerAccessControlEntries(String uid) {
        throw new UnsupportedOperationException("Editing of access control entries is not implemented yet.");
    }

    @Override
    public Future<List<OwnerAccessControlEntry>> getEditableOwnerAccessControlEntries(Callback<List<OwnerAccessControlEntry>> callback, String uid) {
        throw new UnsupportedOperationException("Editing of access control entries is not implemented yet.");
    }

    @Override
    public boolean updateOwnerAccessControlEntry(OwnerAccessControlEntry updatedOwnerAce) {
        return this.globalDomainAccessControllerClient.updateOwnerAccessControlEntry(updatedOwnerAce);
    }

    @Override
    public Future<Boolean> updateOwnerAccessControlEntry(Callback<Boolean> callback, OwnerAccessControlEntry updatedOwnerAce) {
        return this.globalDomainAccessControllerClient.updateOwnerAccessControlEntry(callback, updatedOwnerAce);
    }

    @Override
    public boolean removeOwnerAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        return this.globalDomainAccessControllerClient.removeOwnerAccessControlEntry(uid, domain, interfaceName, operation);
    }

    @Override
    public Future<Boolean> removeOwnerAccessControlEntry(Callback<Boolean> callback, String uid, String domain, String interfaceName, String operation) {
        return this.globalDomainAccessControllerClient.removeOwnerAccessControlEntry(callback, uid, domain, interfaceName, operation);
    }

    @Override
    public Permission getProviderPermission(String uid, String domain, String interfaceName, TrustLevel trustLevel) {
        throw new UnsupportedOperationException("Provider registration permission check is not implemented yet.");
    }

    @Override
    public List<MasterRegistrationControlEntry> getMasterRegistrationControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getMasterRegistrationControlEntries(uid);
    }

    @Override
    public Future<List<MasterRegistrationControlEntry>> getMasterRegistrationControlEntries(Callback<List<MasterRegistrationControlEntry>> callback, String uid) {
        return this.globalDomainAccessControllerClient.getMasterRegistrationControlEntries(callback, uid);
    }

    @Override
    public List<MasterRegistrationControlEntry> getEditableMasterRegistrationControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getEditableMasterRegistrationControlEntries(uid);
    }

    @Override
    public Future<List<MasterRegistrationControlEntry>> getEditableMasterRegistrationControlEntries(Callback<List<MasterRegistrationControlEntry>> callback, String uid) {
        return this.globalDomainAccessControllerClient.getEditableMasterRegistrationControlEntries(callback, uid);
    }

    @Override
    public boolean updateMasterRegistrationControlEntry(MasterRegistrationControlEntry updatedMasterRce) {
        throw new UnsupportedOperationException("Provider registration permission check is not implemented yet.");
    }

    @Override
    public boolean removeMasterRegistrationControlEntry(String uid, String domain, String interfaceName) {
        throw new UnsupportedOperationException("Provider registration permission check is not implemented yet.");
    }

    @Override
    public List<MasterRegistrationControlEntry> getMediatorRegistrationControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getMediatorRegistrationControlEntries(uid);
    }

    @Override
    public Future<List<MasterRegistrationControlEntry>> getMediatorRegistrationControlEntries(Callback<List<MasterRegistrationControlEntry>> callback, String uid) {
        return this.globalDomainAccessControllerClient.getMediatorRegistrationControlEntries(callback, uid);
    }

    @Override
    public List<MasterRegistrationControlEntry> getEditableMediatorRegistrationControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getEditableMediatorRegistrationControlEntries(uid);
    }

    @Override
    public Future<List<MasterRegistrationControlEntry>> getEditableMediatorRegistrationControlEntries(Callback<List<MasterRegistrationControlEntry>> callback, String uid) {
        return this.globalDomainAccessControllerClient.getEditableMasterRegistrationControlEntries(callback, uid);
    }

    @Override
    public boolean updateMediatorRegistrationControlEntry(MasterRegistrationControlEntry updatedMediatorRce) {
        throw new UnsupportedOperationException("Provider registration permission check is not implemented yet.");
    }

    @Override
    public boolean removeMediatorRegistrationControlEntry(String uid, String domain, String interfaceName) {
        throw new UnsupportedOperationException("Provider registration permission check is not implemented yet.");
    }

    @Override
    public List<OwnerRegistrationControlEntry> getOwnerRegistrationControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getOwnerRegistrationControlEntries(uid);
    }

    @Override
    public Future<List<OwnerRegistrationControlEntry>> getOwnerRegistrationControlEntries(Callback<List<OwnerRegistrationControlEntry>> callback, String uid) {
        return this.globalDomainAccessControllerClient.getOwnerRegistrationControlEntries(callback, uid);
    }

    @Override
    public List<OwnerRegistrationControlEntry> getEditableOwnerRegistrationControlEntries(String uid) {
        return this.globalDomainAccessControllerClient.getEditableOwnerRegistrationControlEntries(uid);
    }

    @Override
    public Future<List<OwnerRegistrationControlEntry>> getEditableOwnerRegistrationControlEntries(Callback<List<OwnerRegistrationControlEntry>> callback, String uid) {
        return this.globalDomainAccessControllerClient.getEditableOwnerRegistrationControlEntries(callback, uid);
    }

    @Override
    public boolean updateOwnerRegistrationControlEntry(OwnerRegistrationControlEntry updatedOwnerRce) {
        throw new UnsupportedOperationException("Provider registration permission check is not implemented yet.");
    }

    @Override
    public boolean removeOwnerRegistrationControlEntry(String uid, String domain, String interfaceName) {
        throw new UnsupportedOperationException("Provider registration permission check is not implemented yet.");
    }

    @Override
    public void unsubscribeFromAceChanges(String domain, String interfaceName) {
        UserDomainInterfaceOperationKey subscriptionKey = new UserDomainInterfaceOperationKey(null, domain, interfaceName, null);
        AceSubscription subscriptions = this.subscriptionsMap.get(subscriptionKey);
        if (subscriptions != null) {
            this.globalDomainAccessControllerClient.unsubscribeFromMasterAccessControlEntryChangedBroadcast(subscriptions.getMasterSubscriptionId());
            this.globalDomainAccessControllerClient.unsubscribeFromMediatorAccessControlEntryChangedBroadcast(subscriptions.getMediatorSubscriptionId());
            this.globalDomainAccessControllerClient.unsubscribeFromOwnerAccessControlEntryChangedBroadcast(subscriptions.getOwnerSubscriptionId());
        } else {
            LOG.debug("Subscription for ace subscription for interface '{}' domain '{}'", (Object)interfaceName, (Object)domain);
        }
    }

    private void subscribeForDreChange(String userId) {
        long wsbExpiryDate = System.currentTimeMillis() + 315360000000L;
        OnChangeSubscriptionQos broadcastSubscriptionQos = new OnChangeSubscriptionQos();
        broadcastSubscriptionQos.setMinIntervalMs(1000L).setExpiryDateMs(wsbExpiryDate).setPublicationTtlMs(5000L);
        GlobalDomainAccessControllerBroadcastInterface.DomainRoleEntryChangedBroadcastFilterParameters domainRoleFilterParameters = new GlobalDomainAccessControllerBroadcastInterface.DomainRoleEntryChangedBroadcastFilterParameters();
        domainRoleFilterParameters.setUserIdOfInterest(userId);
        this.globalDomainAccessControllerClient.subscribeToDomainRoleEntryChangedBroadcast(new LdacDomainRoleEntryChangedBroadcastListener(this.localDomainAccessStore), broadcastSubscriptionQos, domainRoleFilterParameters);
    }

    private AceSubscription subscribeForAceChange(String domain, String interfaceName) {
        long wsbExpiryDate = System.currentTimeMillis() + 315360000000L;
        OnChangeSubscriptionQos broadcastSubscriptionQos = new OnChangeSubscriptionQos();
        broadcastSubscriptionQos.setMinIntervalMs(1000L).setExpiryDateMs(wsbExpiryDate).setPublicationTtlMs(5000L);
        GlobalDomainAccessControllerBroadcastInterface.MasterAccessControlEntryChangedBroadcastFilterParameters masterAcefilterParameters = new GlobalDomainAccessControllerBroadcastInterface.MasterAccessControlEntryChangedBroadcastFilterParameters();
        masterAcefilterParameters.setDomainOfInterest(domain);
        masterAcefilterParameters.setInterfaceOfInterest(interfaceName);
        String masterSubscriptionId = this.globalDomainAccessControllerClient.subscribeToMasterAccessControlEntryChangedBroadcast(new LdacMasterAccessControlEntryChangedBroadcastListener(this.localDomainAccessStore), broadcastSubscriptionQos, masterAcefilterParameters);
        GlobalDomainAccessControllerBroadcastInterface.MediatorAccessControlEntryChangedBroadcastFilterParameters mediatorAceFilterParameters = new GlobalDomainAccessControllerBroadcastInterface.MediatorAccessControlEntryChangedBroadcastFilterParameters();
        mediatorAceFilterParameters.setDomainOfInterest(domain);
        mediatorAceFilterParameters.setInterfaceOfInterest(interfaceName);
        String mediatorSubscriptionId = this.globalDomainAccessControllerClient.subscribeToMediatorAccessControlEntryChangedBroadcast(new LdacMediatorAccessControlEntryChangedBroadcastListener(this.localDomainAccessStore), broadcastSubscriptionQos, mediatorAceFilterParameters);
        GlobalDomainAccessControllerBroadcastInterface.OwnerAccessControlEntryChangedBroadcastFilterParameters ownerAceFilterParameters = new GlobalDomainAccessControllerBroadcastInterface.OwnerAccessControlEntryChangedBroadcastFilterParameters();
        ownerAceFilterParameters.setDomainOfInterest(domain);
        ownerAceFilterParameters.setInterfaceOfInterest(interfaceName);
        String ownerSubscriptionId = this.globalDomainAccessControllerClient.subscribeToOwnerAccessControlEntryChangedBroadcast(new LdacOwnerAccessControlEntryChangedBroadcastListener(this.localDomainAccessStore), broadcastSubscriptionQos, ownerAceFilterParameters);
        return new AceSubscription(masterSubscriptionId, mediatorSubscriptionId, ownerSubscriptionId);
    }

    private void initializeLocalDomainAccessStore(String userId, String domain, String interfaceName) {
        List<OwnerAccessControlEntry> list;
        List<MasterAccessControlEntry> list2;
        List<MasterAccessControlEntry> masterAccessControlEntries;
        LOG.debug("initializeLocalDomainAccessStore on domain {}, interface {}", (Object)domain, (Object)interfaceName);
        List<DomainRoleEntry> domainRoleEntries = this.globalDomainAccessControllerClient.getDomainRoles(userId);
        if (domainRoleEntries != null) {
            for (DomainRoleEntry domainRoleEntry : domainRoleEntries) {
                this.localDomainAccessStore.updateDomainRole(domainRoleEntry);
            }
        }
        if ((masterAccessControlEntries = this.globalDomainAccessControllerClient.getMasterAccessControlEntries(domain, interfaceName)) != null) {
            for (MasterAccessControlEntry masterAccessControlEntry : masterAccessControlEntries) {
                this.localDomainAccessStore.updateMasterAccessControlEntry(masterAccessControlEntry);
            }
        }
        if ((list2 = this.globalDomainAccessControllerClient.getMediatorAccessControlEntries(domain, interfaceName)) != null) {
            for (MasterAccessControlEntry entry : list2) {
                this.localDomainAccessStore.updateMediatorAccessControlEntry(entry);
            }
        }
        if ((list = this.globalDomainAccessControllerClient.getOwnerAccessControlEntries(domain, interfaceName)) != null) {
            for (OwnerAccessControlEntry entry : list) {
                this.localDomainAccessStore.updateOwnerAccessControlEntry(entry);
            }
        }
        LOG.debug("Finished initializeLocalDomainAccessStore on domain {}, interface {}", (Object)domain, (Object)interfaceName);
    }

    static class AceSubscription {
        private final String masterSubscriptionId;
        private final String mediatorSubscriptionId;
        private final String ownerSubscriptionId;

        public AceSubscription(String masterSubscriptionId, String mediatorSubscriptionId, String ownerSubscriptionId) {
            this.masterSubscriptionId = masterSubscriptionId;
            this.mediatorSubscriptionId = mediatorSubscriptionId;
            this.ownerSubscriptionId = ownerSubscriptionId;
        }

        public String getMasterSubscriptionId() {
            return this.masterSubscriptionId;
        }

        public String getMediatorSubscriptionId() {
            return this.mediatorSubscriptionId;
        }

        public String getOwnerSubscriptionId() {
            return this.ownerSubscriptionId;
        }
    }
}

