/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.broadcastlistener;

import io.joynr.accesscontrol.DomainAccessControlStore;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.GlobalDomainAccessControllerBroadcastInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdacDomainRoleEntryChangedBroadcastListener
implements GlobalDomainAccessControllerBroadcastInterface.DomainRoleEntryChangedBroadcastListener {
    private static final Logger LOG = LoggerFactory.getLogger(LdacDomainRoleEntryChangedBroadcastListener.class);
    private final DomainAccessControlStore localDomainAccessStore;

    public LdacDomainRoleEntryChangedBroadcastListener(DomainAccessControlStore domainAccessControlStore) {
        this.localDomainAccessStore = domainAccessControlStore;
    }

    public void onReceive(ChangeType typeOfChange, DomainRoleEntry newDomainRoleEntry) {
        if (!typeOfChange.equals((Object)ChangeType.REMOVE)) {
            this.localDomainAccessStore.updateDomainRole(newDomainRoleEntry);
            LOG.debug("Updated DRE: {}", (Object)newDomainRoleEntry.toString());
        } else {
            this.localDomainAccessStore.removeDomainRole(newDomainRoleEntry.getUid(), newDomainRoleEntry.getRole());
            LOG.debug("Removed DRE: {}", (Object)newDomainRoleEntry.toString());
        }
    }

    public void onError() {
        LOG.error("Update of DRE failed!");
    }
}

