/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.broadcastlistener;

import io.joynr.accesscontrol.DomainAccessControlStore;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.GlobalDomainAccessControllerBroadcastInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdacMasterAccessControlEntryChangedBroadcastListener
implements GlobalDomainAccessControllerBroadcastInterface.MasterAccessControlEntryChangedBroadcastListener {
    private static final Logger LOG = LoggerFactory.getLogger(LdacMasterAccessControlEntryChangedBroadcastListener.class);
    private DomainAccessControlStore localDomainAccessStore;

    public LdacMasterAccessControlEntryChangedBroadcastListener(DomainAccessControlStore domainAccessControlStore) {
        this.localDomainAccessStore = domainAccessControlStore;
    }

    public void onReceive(ChangeType typeOfChange, MasterAccessControlEntry newMasterAce) {
        if (!typeOfChange.equals((Object)ChangeType.REMOVE)) {
            this.localDomainAccessStore.updateMasterAccessControlEntry(newMasterAce);
            LOG.debug("Updated master ACE: {}", (Object)newMasterAce.toString());
        } else {
            this.localDomainAccessStore.removeMasterAccessControlEntry(newMasterAce.getUid(), newMasterAce.getDomain(), newMasterAce.getInterfaceName(), newMasterAce.getOperation());
            LOG.debug("Removed master ACE: {}", (Object)newMasterAce.toString());
        }
    }

    public void onError() {
        LOG.error("Update masterAce failed!");
    }
}

