/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.broadcastlistener;

import io.joynr.accesscontrol.DomainAccessControlStore;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.GlobalDomainAccessControllerBroadcastInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdacOwnerAccessControlEntryChangedBroadcastListener
implements GlobalDomainAccessControllerBroadcastInterface.OwnerAccessControlEntryChangedBroadcastListener {
    private static final Logger LOG = LoggerFactory.getLogger(LdacOwnerAccessControlEntryChangedBroadcastListener.class);
    private DomainAccessControlStore localDomainAccessStore;

    public LdacOwnerAccessControlEntryChangedBroadcastListener(DomainAccessControlStore domainAccessControlStore) {
        this.localDomainAccessStore = domainAccessControlStore;
    }

    public void onReceive(ChangeType typeOfChange, OwnerAccessControlEntry newOwnerAce) {
        if (!typeOfChange.equals((Object)ChangeType.REMOVE)) {
            this.localDomainAccessStore.updateOwnerAccessControlEntry(newOwnerAce);
            LOG.debug("Updated owner ACE: {}", (Object)newOwnerAce.toString());
        } else {
            this.localDomainAccessStore.removeOwnerAccessControlEntry(newOwnerAce.getUid(), newOwnerAce.getDomain(), newOwnerAce.getInterfaceName(), newOwnerAce.getOperation());
            LOG.debug("Removed owner ACE: {}", (Object)newOwnerAce.toString());
        }
    }

    public void onError() {
        LOG.error("Update ownerAce failed!");
    }
}

