/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.DiscoveryScope;
import io.joynr.capabilities.AbstractLocalCapabilitiesDirectory;
import io.joynr.capabilities.CapabilitiesCallback;
import io.joynr.capabilities.CapabilitiesProvisioning;
import io.joynr.capabilities.CapabilityCallback;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.capabilities.DiscoveryEntryStore;
import io.joynr.capabilities.GlobalCapabilitiesDirectoryClient;
import io.joynr.exceptions.DiscoveryException;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.TransportReadyListener;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import io.joynr.proxy.Callback;
import io.joynr.proxy.Future;
import io.joynr.runtime.GlobalAddressProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import joynr.exceptions.ApplicationException;
import joynr.exceptions.ProviderRuntimeException;
import joynr.system.DiscoveryProvider;
import joynr.system.RoutingTypes.Address;
import joynr.types.DiscoveryEntry;
import joynr.types.DiscoveryQos;
import joynr.types.GlobalDiscoveryEntry;
import joynr.types.ProviderScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalCapabilitiesDirectoryImpl
extends AbstractLocalCapabilitiesDirectory
implements TransportReadyListener {
    private static final Logger logger = LoggerFactory.getLogger(LocalCapabilitiesDirectoryImpl.class);
    private static final Set<DiscoveryScope> INCLUDE_LOCAL_SCOPES = new HashSet<DiscoveryScope>();
    private static final Set<DiscoveryScope> INCLUDE_GLOBAL_SCOPES;
    private DiscoveryEntryStore localDiscoveryEntryStore;
    private GlobalCapabilitiesDirectoryClient globalCapabilitiesDirectoryClient;
    private DiscoveryEntryStore globalDiscoveryEntryCache;
    private static final long DEFAULT_DISCOVERYTIMEOUT = 30000L;
    private MessageRouter messageRouter;
    private GlobalAddressProvider globalAddressProvider;
    private Address globalAddress;
    private Object globalAddressLock = new Object();
    private List<QueuedDiscoveryEntry> queuedDiscoveryEntries = new ArrayList<QueuedDiscoveryEntry>();

    @Inject
    public LocalCapabilitiesDirectoryImpl(CapabilitiesProvisioning capabilitiesProvisioning, GlobalAddressProvider globalAddressProvider, DiscoveryEntryStore localDiscoveryEntryStore, DiscoveryEntryStore globalDiscoveryEntryCache, MessageRouter messageRouter, GlobalCapabilitiesDirectoryClient globalCapabilitiesDirectoryClient) {
        this.globalAddressProvider = globalAddressProvider;
        this.messageRouter = messageRouter;
        this.localDiscoveryEntryStore = localDiscoveryEntryStore;
        this.globalDiscoveryEntryCache = globalDiscoveryEntryCache;
        this.globalCapabilitiesDirectoryClient = globalCapabilitiesDirectoryClient;
        this.globalDiscoveryEntryCache.add(capabilitiesProvisioning.getDiscoveryEntries());
    }

    public Promise<DeferredVoid> add(DiscoveryEntry discoveryEntry) {
        DeferredVoid deferred = new DeferredVoid();
        if (this.localDiscoveryEntryStore.hasDiscoveryEntry(discoveryEntry)) {
            io.joynr.arbitration.DiscoveryQos discoveryQos = new io.joynr.arbitration.DiscoveryQos(30000L, ArbitrationStrategy.HighestPriority, Long.MAX_VALUE, DiscoveryScope.LOCAL_AND_GLOBAL);
            if (discoveryEntry.getQos().getScope().equals((Object)ProviderScope.LOCAL) || this.globalDiscoveryEntryCache.lookup(discoveryEntry.getParticipantId(), discoveryQos.getCacheMaxAgeMs()) != null) {
                deferred.resolve();
                return new Promise((AbstractDeferred)deferred);
            }
        } else {
            this.localDiscoveryEntryStore.add(discoveryEntry);
            this.notifyCapabilityAdded(discoveryEntry);
        }
        if (discoveryEntry.getQos().getScope().equals((Object)ProviderScope.GLOBAL)) {
            this.registerGlobal(discoveryEntry, deferred);
        } else {
            deferred.resolve();
        }
        return new Promise((AbstractDeferred)deferred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerGlobal(final DiscoveryEntry discoveryEntry, final DeferredVoid deferred) {
        Object object = this.globalAddressLock;
        synchronized (object) {
            try {
                this.globalAddress = this.globalAddressProvider.get();
            }
            catch (Exception e) {
                logger.debug("error getting global address", (Throwable)e);
                this.globalAddress = null;
            }
            if (this.globalAddress == null) {
                this.queuedDiscoveryEntries.add(new QueuedDiscoveryEntry(discoveryEntry, deferred));
                this.globalAddressProvider.registerGlobalAddressesReadyListener(this);
                return;
            }
        }
        final GlobalDiscoveryEntry globalDiscoveryEntry = CapabilityUtils.discoveryEntry2GlobalDiscoveryEntry((DiscoveryEntry)discoveryEntry, (Address)this.globalAddress);
        if (globalDiscoveryEntry != null) {
            logger.info("starting global registration for " + globalDiscoveryEntry.getDomain() + " : " + globalDiscoveryEntry.getInterfaceName());
            this.globalCapabilitiesDirectoryClient.add((Callback)new Callback<Void>(){

                public void onSuccess(Void nothing) {
                    logger.info("global registration for " + globalDiscoveryEntry.getDomain() + " : " + globalDiscoveryEntry.getInterfaceName() + " completed");
                    deferred.resolve();
                    LocalCapabilitiesDirectoryImpl.this.globalDiscoveryEntryCache.add((DiscoveryEntry)CapabilityUtils.discoveryEntry2GlobalDiscoveryEntry((DiscoveryEntry)discoveryEntry, (Address)LocalCapabilitiesDirectoryImpl.this.globalAddress));
                }

                public void onFailure(JoynrRuntimeException exception) {
                    deferred.reject(new ProviderRuntimeException(exception.toString()));
                }
            }, globalDiscoveryEntry);
        }
    }

    public void remove(final DiscoveryEntry discoveryEntry) {
        this.localDiscoveryEntryStore.remove(discoveryEntry.getParticipantId());
        this.notifyCapabilityRemoved(discoveryEntry);
        if (discoveryEntry.getQos().getScope() != ProviderScope.LOCAL) {
            Callback<Void> callback = new Callback<Void>(){

                public void onSuccess(Void result) {
                    LocalCapabilitiesDirectoryImpl.this.globalDiscoveryEntryCache.remove(discoveryEntry.getParticipantId());
                }

                public void onFailure(JoynrRuntimeException error) {
                }
            };
            this.globalCapabilitiesDirectoryClient.remove((Callback)callback, Arrays.asList(discoveryEntry.getParticipantId()));
        }
        this.messageRouter.removeNextHop(discoveryEntry.getParticipantId());
    }

    public void lookup(String[] domains, String interfaceName, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilitiesCallback capabilitiesCallback) {
        DiscoveryScope discoveryScope = discoveryQos.getDiscoveryScope();
        Set<DiscoveryEntry> localDiscoveryEntries = this.getLocalEntriesIfRequired(discoveryScope, domains, interfaceName);
        Set<DiscoveryEntry> globalDiscoveryEntries = this.getGloballyCachedEntriesIfRequired(discoveryScope, domains, interfaceName, discoveryQos.getCacheMaxAgeMs());
        switch (discoveryScope) {
            case LOCAL_ONLY: {
                capabilitiesCallback.processCapabilitiesReceived(localDiscoveryEntries);
                break;
            }
            case LOCAL_THEN_GLOBAL: {
                this.handleLocalThenGlobal(domains, interfaceName, discoveryQos, capabilitiesCallback, localDiscoveryEntries, globalDiscoveryEntries);
                break;
            }
            case GLOBAL_ONLY: {
                this.handleGlobalOnly(domains, interfaceName, discoveryQos, capabilitiesCallback, globalDiscoveryEntries);
                break;
            }
            case LOCAL_AND_GLOBAL: {
                this.handleLocalAndGlobal(domains, interfaceName, discoveryQos, capabilitiesCallback, localDiscoveryEntries, globalDiscoveryEntries);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown or illegal DiscoveryScope value: " + discoveryScope);
            }
        }
    }

    private void handleLocalThenGlobal(String[] domains, String interfaceName, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilitiesCallback capabilitiesCallback, Set<DiscoveryEntry> localDiscoveryEntries, Set<DiscoveryEntry> globalDiscoveryEntries) {
        HashSet<String> domainsForGlobalLookup = new HashSet<String>();
        HashSet<DiscoveryEntry> matchedDiscoveryEntries = new HashSet<DiscoveryEntry>();
        for (String domainToMatch : domains) {
            boolean domainMatched = this.addEntriesForDomain(localDiscoveryEntries, matchedDiscoveryEntries, domainToMatch);
            boolean bl = domainMatched = domainMatched || this.addEntriesForDomain(globalDiscoveryEntries, matchedDiscoveryEntries, domainToMatch);
            if (domainMatched) continue;
            domainsForGlobalLookup.add(domainToMatch);
        }
        this.handleMissingGlobalEntries(interfaceName, discoveryQos, capabilitiesCallback, domainsForGlobalLookup, matchedDiscoveryEntries);
    }

    private void handleLocalAndGlobal(String[] domains, String interfaceName, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilitiesCallback capabilitiesCallback, Set<DiscoveryEntry> localDiscoveryEntries, Set<DiscoveryEntry> globalDiscoveryEntries) {
        HashSet<String> domainsForGlobalLookup = new HashSet<String>();
        HashSet<DiscoveryEntry> matchedDiscoveryEntries = new HashSet<DiscoveryEntry>();
        for (String domainToMatch : domains) {
            this.addEntriesForDomain(localDiscoveryEntries, matchedDiscoveryEntries, domainToMatch);
            if (this.addEntriesForDomain(globalDiscoveryEntries, matchedDiscoveryEntries, domainToMatch)) continue;
            domainsForGlobalLookup.add(domainToMatch);
        }
        this.handleMissingGlobalEntries(interfaceName, discoveryQos, capabilitiesCallback, domainsForGlobalLookup, matchedDiscoveryEntries);
    }

    private void handleGlobalOnly(String[] domains, String interfaceName, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilitiesCallback capabilitiesCallback, Set<DiscoveryEntry> globalDiscoveryEntries) {
        HashSet domainsForGlobalLookup = Sets.newHashSet((Object[])domains);
        for (DiscoveryEntry discoveryEntry : globalDiscoveryEntries) {
            domainsForGlobalLookup.remove(discoveryEntry.getDomain());
        }
        this.handleMissingGlobalEntries(interfaceName, discoveryQos, capabilitiesCallback, domainsForGlobalLookup, globalDiscoveryEntries);
    }

    private void handleMissingGlobalEntries(String interfaceName, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilitiesCallback capabilitiesCallback, Set<String> domainsForGlobalLookup, Set<DiscoveryEntry> matchedDiscoveryEntries) {
        if (domainsForGlobalLookup.isEmpty()) {
            capabilitiesCallback.processCapabilitiesReceived(matchedDiscoveryEntries);
        } else {
            this.asyncGetGlobalCapabilitities(domainsForGlobalLookup.toArray(new String[domainsForGlobalLookup.size()]), interfaceName, matchedDiscoveryEntries, discoveryQos.getDiscoveryTimeoutMs(), capabilitiesCallback);
        }
    }

    private boolean addEntriesForDomain(Collection<DiscoveryEntry> discoveryEntries, Collection<DiscoveryEntry> addTo, String domain) {
        boolean domainMatched = false;
        for (DiscoveryEntry discoveryEntry : discoveryEntries) {
            if (!discoveryEntry.getDomain().equals(domain)) continue;
            addTo.add(discoveryEntry);
            domainMatched = true;
        }
        return domainMatched;
    }

    private Set<DiscoveryEntry> getGloballyCachedEntriesIfRequired(DiscoveryScope discoveryScope, String[] domains, String interfaceName, long cacheMaxAge) {
        if (INCLUDE_GLOBAL_SCOPES.contains(discoveryScope)) {
            return new HashSet<DiscoveryEntry>(this.globalDiscoveryEntryCache.lookup(domains, interfaceName, cacheMaxAge));
        }
        return null;
    }

    private Set<DiscoveryEntry> getLocalEntriesIfRequired(DiscoveryScope discoveryScope, String[] domains, String interfaceName) {
        if (INCLUDE_LOCAL_SCOPES.contains(discoveryScope)) {
            return new HashSet<DiscoveryEntry>(this.localDiscoveryEntryStore.lookup(domains, interfaceName));
        }
        return null;
    }

    @CheckForNull
    public void lookup(String participantId, io.joynr.arbitration.DiscoveryQos discoveryQos, CapabilityCallback capabilityCallback) {
        DiscoveryEntry localDiscoveryEntry = this.localDiscoveryEntryStore.lookup(participantId, discoveryQos.getCacheMaxAgeMs());
        DiscoveryScope discoveryScope = discoveryQos.getDiscoveryScope();
        switch (discoveryScope) {
            case LOCAL_ONLY: {
                capabilityCallback.processCapabilityReceived(localDiscoveryEntry);
                break;
            }
            case LOCAL_THEN_GLOBAL: 
            case LOCAL_AND_GLOBAL: {
                if (localDiscoveryEntry != null) {
                    capabilityCallback.processCapabilityReceived(localDiscoveryEntry);
                    break;
                }
                this.asyncGetGlobalCapabilitity(participantId, discoveryQos, capabilityCallback);
                break;
            }
            case GLOBAL_ONLY: {
                this.asyncGetGlobalCapabilitity(participantId, discoveryQos, capabilityCallback);
                break;
            }
        }
    }

    @CheckForNull
    public DiscoveryEntry lookup(String participantId, io.joynr.arbitration.DiscoveryQos discoveryQos) {
        final Future lookupFuture = new Future();
        this.lookup(participantId, discoveryQos, new CapabilityCallback(){

            public void processCapabilityReceived(DiscoveryEntry capability) {
                lookupFuture.onSuccess((Object)capability);
            }

            public void onError(Throwable e) {
                lookupFuture.onFailure((JoynrException)new JoynrRuntimeException(e));
            }
        });
        DiscoveryEntry retrievedCapabilitiyEntry = null;
        try {
            retrievedCapabilitiyEntry = (DiscoveryEntry)lookupFuture.get();
        }
        catch (InterruptedException e1) {
            logger.error("interrupted while retrieving capability entry by participant ID", (Throwable)e1);
        }
        catch (ApplicationException e1) {
            logger.error("ApplicationException while retrieving capability entry by participant ID", (Throwable)e1);
        }
        return retrievedCapabilitiyEntry;
    }

    private void registerIncomingEndpoints(Collection<GlobalDiscoveryEntry> caps) {
        for (GlobalDiscoveryEntry ce : caps) {
            if (ce.getParticipantId() == null || ce.getAddress() == null) continue;
            Address address = CapabilityUtils.getAddressFromGlobalDiscoveryEntry((GlobalDiscoveryEntry)ce);
            this.messageRouter.addNextHop(ce.getParticipantId(), address);
        }
    }

    private void asyncGetGlobalCapabilitity(String participantId, io.joynr.arbitration.DiscoveryQos discoveryQos, final CapabilityCallback capabilitiesCallback) {
        DiscoveryEntry cachedGlobalCapability = this.globalDiscoveryEntryCache.lookup(participantId, discoveryQos.getCacheMaxAgeMs());
        if (cachedGlobalCapability != null) {
            capabilitiesCallback.processCapabilityReceived(cachedGlobalCapability);
        } else {
            this.globalCapabilitiesDirectoryClient.lookup((Callback)new Callback<GlobalDiscoveryEntry>(){

                public void onSuccess(@CheckForNull GlobalDiscoveryEntry newGlobalDiscoveryEntry) {
                    if (newGlobalDiscoveryEntry != null) {
                        LocalCapabilitiesDirectoryImpl.this.registerIncomingEndpoints(Lists.newArrayList((Object[])new GlobalDiscoveryEntry[]{newGlobalDiscoveryEntry}));
                        LocalCapabilitiesDirectoryImpl.this.globalDiscoveryEntryCache.add((DiscoveryEntry)newGlobalDiscoveryEntry);
                        capabilitiesCallback.processCapabilityReceived((DiscoveryEntry)newGlobalDiscoveryEntry);
                    } else {
                        capabilitiesCallback.onError((Throwable)new NullPointerException("Received capabilities are null"));
                    }
                }

                public void onFailure(JoynrRuntimeException exception) {
                    capabilitiesCallback.onError((Throwable)exception);
                }
            }, participantId, discoveryQos.getDiscoveryTimeoutMs());
        }
    }

    private void asyncGetGlobalCapabilitities(String[] domains, String interfaceName, Collection<DiscoveryEntry> localDiscoveryEntries2, long discoveryTimeout, final CapabilitiesCallback capabilitiesCallback) {
        final LinkedList localDiscoveryEntries = localDiscoveryEntries2 == null ? new LinkedList() : localDiscoveryEntries2;
        this.globalCapabilitiesDirectoryClient.lookup((Callback)new Callback<List<GlobalDiscoveryEntry>>(){

            public void onSuccess(List<GlobalDiscoveryEntry> globalDiscoverEntries) {
                if (globalDiscoverEntries != null) {
                    LocalCapabilitiesDirectoryImpl.this.registerIncomingEndpoints(globalDiscoverEntries);
                    LocalCapabilitiesDirectoryImpl.this.globalDiscoveryEntryCache.add(globalDiscoverEntries);
                    ArrayList<GlobalDiscoveryEntry> allDisoveryEntries = new ArrayList<GlobalDiscoveryEntry>(globalDiscoverEntries.size() + localDiscoveryEntries.size());
                    allDisoveryEntries.addAll(globalDiscoverEntries);
                    allDisoveryEntries.addAll(localDiscoveryEntries);
                    capabilitiesCallback.processCapabilitiesReceived(allDisoveryEntries);
                } else {
                    capabilitiesCallback.onError((Throwable)new NullPointerException("Received capabilities are null"));
                }
            }

            public void onFailure(JoynrRuntimeException exception) {
                capabilitiesCallback.onError((Throwable)exception);
            }
        }, domains, interfaceName, discoveryTimeout);
    }

    public void shutdown(boolean unregisterAllRegisteredCapabilities) {
        if (unregisterAllRegisteredCapabilities) {
            Set allDiscoveryEntries = this.localDiscoveryEntryStore.getAllDiscoveryEntries();
            ArrayList<DiscoveryEntry> discoveryEntries = new ArrayList<DiscoveryEntry>(allDiscoveryEntries.size());
            for (DiscoveryEntry capabilityEntry : allDiscoveryEntries) {
                if (capabilityEntry.getQos().getScope() != ProviderScope.GLOBAL) continue;
                discoveryEntries.add(capabilityEntry);
            }
            if (discoveryEntries.size() > 0) {
                try {
                    Function<DiscoveryEntry, String> transfomerFct = new Function<DiscoveryEntry, String>(){

                        public String apply(DiscoveryEntry input) {
                            return input != null ? input.getParticipantId() : null;
                        }
                    };
                    Callback<Void> callback = new Callback<Void>(){

                        public void onFailure(JoynrRuntimeException error) {
                        }

                        public void onSuccess(Void result) {
                        }
                    };
                    this.globalCapabilitiesDirectoryClient.remove((Callback)callback, (List)Lists.newArrayList((Iterable)Collections2.transform(discoveryEntries, (Function)transfomerFct)));
                }
                catch (DiscoveryException e) {
                    logger.debug("error removing discovery entries", (Throwable)e);
                }
            }
        }
    }

    public Promise<DiscoveryProvider.Lookup1Deferred> lookup(String[] domains, String interfaceName, DiscoveryQos discoveryQos) {
        final DiscoveryProvider.Lookup1Deferred deferred = new DiscoveryProvider.Lookup1Deferred();
        CapabilitiesCallback callback = new CapabilitiesCallback(){

            public void processCapabilitiesReceived(@CheckForNull Collection<DiscoveryEntry> capabilities) {
                if (capabilities == null) {
                    deferred.reject(new ProviderRuntimeException("Received capablities collection was null"));
                } else {
                    deferred.resolve(capabilities.toArray(new DiscoveryEntry[capabilities.size()]));
                }
            }

            public void onError(Throwable e) {
                deferred.reject(new ProviderRuntimeException(e.toString()));
            }
        };
        DiscoveryScope discoveryScope = DiscoveryScope.valueOf((String)discoveryQos.getDiscoveryScope().name());
        this.lookup(domains, interfaceName, new io.joynr.arbitration.DiscoveryQos(30000L, ArbitrationStrategy.NotSet, discoveryQos.getCacheMaxAge().longValue(), discoveryScope), callback);
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DiscoveryProvider.Lookup2Deferred> lookup(String participantId) {
        DiscoveryProvider.Lookup2Deferred deferred = new DiscoveryProvider.Lookup2Deferred();
        DiscoveryEntry discoveryEntry = this.lookup(participantId, io.joynr.arbitration.DiscoveryQos.NO_FILTER);
        deferred.resolve(discoveryEntry);
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> remove(String participantId) {
        DeferredVoid deferred = new DeferredVoid();
        DiscoveryEntry entryToRemove = this.localDiscoveryEntryStore.lookup(participantId, Long.MAX_VALUE);
        if (entryToRemove != null) {
            this.remove(entryToRemove);
            deferred.resolve();
        } else {
            deferred.reject(new ProviderRuntimeException("Failed to remove participantId: " + participantId));
        }
        return new Promise((AbstractDeferred)deferred);
    }

    public Set<DiscoveryEntry> listLocalCapabilities() {
        return this.localDiscoveryEntryStore.getAllDiscoveryEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transportReady(@Nonnull Address address) {
        Iterator<QueuedDiscoveryEntry> iterator = this.globalAddressLock;
        synchronized (iterator) {
            this.globalAddress = address;
        }
        for (QueuedDiscoveryEntry queuedDiscoveryEntry : this.queuedDiscoveryEntries) {
            this.registerGlobal(queuedDiscoveryEntry.getDiscoveryEntry(), queuedDiscoveryEntry.getDeferred());
        }
    }

    static {
        INCLUDE_LOCAL_SCOPES.add(DiscoveryScope.LOCAL_ONLY);
        INCLUDE_LOCAL_SCOPES.add(DiscoveryScope.LOCAL_AND_GLOBAL);
        INCLUDE_LOCAL_SCOPES.add(DiscoveryScope.LOCAL_THEN_GLOBAL);
        INCLUDE_GLOBAL_SCOPES = new HashSet<DiscoveryScope>();
        INCLUDE_GLOBAL_SCOPES.add(DiscoveryScope.GLOBAL_ONLY);
        INCLUDE_GLOBAL_SCOPES.add(DiscoveryScope.LOCAL_AND_GLOBAL);
        INCLUDE_GLOBAL_SCOPES.add(DiscoveryScope.LOCAL_THEN_GLOBAL);
    }

    static class QueuedDiscoveryEntry {
        private DiscoveryEntry discoveryEntry;
        private DeferredVoid deferred;

        public QueuedDiscoveryEntry(DiscoveryEntry discoveryEntry, DeferredVoid deferred) {
            this.discoveryEntry = discoveryEntry;
            this.deferred = deferred;
        }

        public DiscoveryEntry getDiscoveryEntry() {
            return this.discoveryEntry;
        }

        public DeferredVoid getDeferred() {
            return this.deferred;
        }
    }
}

