/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.discovery;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.arbitration.DiscoveryScope;
import io.joynr.capabilities.DiscoveryEntryStore;
import io.joynr.capabilities.DiscoveryEntryStoreInMemory;
import io.joynr.capabilities.LocalCapabilitiesDirectory;
import io.joynr.capabilities.LocalCapabilitiesDirectoryImpl;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.proxy.ProxyBuilderFactory;
import javax.annotation.CheckForNull;
import joynr.system.DiscoveryProxy;

public class DiscoveryClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(LocalCapabilitiesDirectory.class).to(LocalCapabilitiesDirectoryImpl.class).in(Singleton.class);
        this.bind(DiscoveryEntryStore.class).to(DiscoveryEntryStoreInMemory.class);
    }

    @CheckForNull
    @Provides
    @Singleton
    DiscoveryProxy provideDiscoveryProxy(@Named(value="joynr.messaging.systemservicesdomain") String systemServicesDomain, @Named(value="joynr.discovery.requesttimeout") long discoveryRequestTimeoutMs, @Named(value="joynr.messaging.discoveryproviderparticipantid") String discoveryProviderParticipantId, ProxyBuilderFactory proxyBuilderFactory) {
        MessagingQos messagingQos = new MessagingQos(discoveryRequestTimeoutMs);
        DiscoveryQos discoveryQos = new DiscoveryQos(1000L, ArbitrationStrategy.FixedChannel, Long.MAX_VALUE, DiscoveryScope.LOCAL_ONLY);
        discoveryQos.addCustomParameter("fixedParticipantId", discoveryProviderParticipantId);
        ProxyBuilder proxyBuilder = proxyBuilderFactory.get(systemServicesDomain, DiscoveryProxy.class);
        return (DiscoveryProxy)proxyBuilder.setMessagingQos(messagingQos).setDiscoveryQos(discoveryQos).build();
    }
}

