/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.http.HttpGlobalAddressFactory;
import io.joynr.messaging.http.operation.ChannelCreatedListener;
import io.joynr.messaging.http.operation.LongPollingMessageReceiver;
import io.joynr.messaging.routing.TransportReadyListener;
import java.util.ArrayList;
import java.util.List;
import joynr.system.RoutingTypes.Address;

@Singleton
public class LongPollingHttpGlobalAddressFactory
extends HttpGlobalAddressFactory
implements ChannelCreatedListener {
    private static final String SUPPORTED_TRANSPORT_LONGPOLLING = "longpolling";
    private String myChannelId;
    private String messagingEndpointUrl;
    private List<TransportReadyListener> addressReadyListeners = new ArrayList<TransportReadyListener>();

    @Inject
    public LongPollingHttpGlobalAddressFactory(@Named(value="joynr.messaging.channelid") String myChannelId, LongPollingMessageReceiver longPollingMessageReceiver) {
        longPollingMessageReceiver.registerChannelCreatedListener(this);
        this.myChannelId = myChannelId;
    }

    protected String getMyChannelId() {
        return this.myChannelId;
    }

    protected synchronized String getMessagingEndpointUrl() {
        if (this.messagingEndpointUrl == null) {
            throw new IllegalStateException("bounceproxy channel for long polling not yet created");
        }
        return this.messagingEndpointUrl;
    }

    public boolean supportsTransport(String transport) {
        return SUPPORTED_TRANSPORT_LONGPOLLING.equalsIgnoreCase(transport);
    }

    public synchronized void registerGlobalAddressReady(TransportReadyListener listener) {
        this.addressReadyListeners.add(listener);
        if (this.messagingEndpointUrl != null) {
            listener.transportReady((Address)this.create());
        }
    }

    protected synchronized void setMessagingEndpointUrl(String messagingEndpointUrl) {
        this.messagingEndpointUrl = messagingEndpointUrl;
    }

    @Override
    public synchronized void channelCreated(String messagingEndpointUrl) {
        this.setMessagingEndpointUrl(messagingEndpointUrl);
        for (TransportReadyListener listener : this.addressReadyListeners) {
            listener.transportReady((Address)this.create());
        }
    }
}

