/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.channel;

import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.http.HttpMessageSender;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;

public class ChannelMessagingStub
implements IMessaging {
    private ChannelAddress address;
    private JoynrMessageSerializer messageSerializer;
    private HttpMessageSender httpMessageSender;
    private ChannelAddress replyToAddress;

    public ChannelMessagingStub(ChannelAddress address, ChannelAddress replyToAddress, JoynrMessageSerializer messageSerializer, HttpMessageSender httpMessageSender) {
        this.address = address;
        this.replyToAddress = replyToAddress;
        this.messageSerializer = messageSerializer;
        this.httpMessageSender = httpMessageSender;
    }

    public void transmit(JoynrMessage message, FailureAction failureAction) {
        this.setReplyTo(message);
        String serializedMessage = this.messageSerializer.serialize(message);
        this.transmit(serializedMessage, failureAction);
    }

    public void transmit(String serializedMessage, FailureAction failureAction) {
        this.httpMessageSender.sendMessage(this.address, serializedMessage, failureAction);
    }

    private void setReplyTo(JoynrMessage message) {
        String type = message.getType();
        if (type != null && message.getReplyTo() == null && (type.equals("request") || type.equals("subscriptionRequest") || type.equals("broadcastSubscriptionRequest"))) {
            message.setReplyTo(RoutingTypesUtil.toAddressString((Address)this.replyToAddress));
        }
    }
}

