/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http;

import com.google.inject.name.Named;
import io.joynr.messaging.http.operation.HttpConstants;
import io.joynr.messaging.util.Utilities;
import io.joynr.runtime.PropertyLoader;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlResolver {
    private static final Logger logger = LoggerFactory.getLogger(UrlResolver.class);
    private final HttpConstants httpConstants;
    private final Properties hosts;

    @Inject
    public UrlResolver(HttpConstants httpConstants, @Named(value="joynr.messaging.hostsfilename") String hostsFileName) {
        this.httpConstants = httpConstants;
        this.hosts = PropertyLoader.loadProperties((String)hostsFileName);
    }

    String mapHost(String url) throws Exception {
        URL originalUrl = new URL(url);
        String host = originalUrl.getHost();
        if (this.hosts.containsKey(host)) {
            String[] mappedHostInfo = this.hosts.getProperty(host).split(":");
            String mappedHost = mappedHostInfo[0];
            int port = originalUrl.getPort();
            if (mappedHostInfo.length >= 2) {
                port = Integer.parseInt(mappedHostInfo[1]);
            }
            String path = originalUrl.getFile();
            if (mappedHostInfo.length >= 3) {
                String mappedPathFind = mappedHostInfo[2];
                String pathReplace = "";
                if (mappedHostInfo.length >= 4) {
                    pathReplace = mappedHostInfo[3];
                }
                path = path.replaceFirst(mappedPathFind, pathReplace);
            }
            URL newURL = new URL(originalUrl.getProtocol(), mappedHost, port, path);
            url = newURL.toExternalForm();
        }
        return url;
    }

    private String encodeSendUrl(String encodedChannelUrl) {
        if (Utilities.isSessionEncodedInUrl((String)encodedChannelUrl, (String)this.httpConstants.getHTTP_SESSION_ID_NAME())) {
            String channelUrlWithoutSessionId = Utilities.getUrlWithoutSessionId((String)encodedChannelUrl, (String)this.httpConstants.getHTTP_SESSION_ID_NAME());
            String sessionId = Utilities.getSessionId((String)encodedChannelUrl, (String)this.httpConstants.getHTTP_SESSION_ID_NAME());
            return Utilities.getSessionEncodedUrl((String)(channelUrlWithoutSessionId + "message/"), (String)this.httpConstants.getHTTP_SESSION_ID_NAME(), (String)sessionId);
        }
        return encodedChannelUrl + "message/";
    }

    @Nullable
    public String getSendUrl(String url) {
        String sendUrl = this.encodeSendUrl(url);
        try {
            sendUrl = this.mapHost(sendUrl);
        }
        catch (Exception e) {
            logger.error("error in URL mapping while sending to url: {} reason: {}", (Object)url, (Object)e.getMessage());
        }
        return sendUrl;
    }
}

