/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http.operation;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.MessagingSettings;
import io.joynr.messaging.http.operation.HttpConstants;
import java.util.Properties;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class HttpClientProvider
implements Provider<CloseableHttpClient> {
    protected final MessagingSettings settings;
    protected Properties properties;
    private HttpConstants httpConstants;

    @Inject
    public HttpClientProvider(MessagingSettings settings, @Named(value="joynr.properties") Properties properties, HttpConstants httpConstants) {
        this.settings = settings;
        this.properties = properties;
        this.httpConstants = httpConstants;
    }

    public CloseableHttpClient get() {
        return this.createHttpClient(this.settings, this.properties);
    }

    public CloseableHttpClient createHttpClient(MessagingSettings mySettings, Properties withProperties) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultCredentialsProvider(null).setMaxConnTotal(this.httpConstants.getHTTP_MAXIMUM_CONNECTIONS_TOTAL()).setMaxConnPerRoute(this.httpConstants.getHTTP_MAXIMUM_CONNECTIONS_TO_HOST()).useSystemProperties();
        String proxyHost = withProperties.getProperty("http.proxyhost");
        if (proxyHost != null) {
            int proxyPort = 8080;
            try {
                proxyPort = Integer.parseInt(withProperties.getProperty("http.proxyport"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String proxyUser = withProperties.getProperty("http.proxyuser");
            if (proxyUser != null) {
                String proxyPassword = withProperties.getProperty("http.proxypassword");
                proxyPassword = proxyPassword == null ? "" : proxyPassword;
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        return httpClientBuilder.build();
    }
}

